unit mpi;
(*
				  COPYRIGHT

The following is a notice of limited availability of the code, and disclaimer
which must be included in the prologue of the code and in all source listings
of the code.

Copyright Notice
 + 1993 University of Chicago
 + 1993 Mississippi State University

Permission is hereby granted to use, reproduce, prepare derivative works, and
to redistribute to others.  This software was authored by:

Argonne National Laboratory Group
W. Gropp: (630) 252-4318; FAX: (708) 252-7852; e-mail: gropp@mcs.anl.gov
E. Lusk: (630) 252-7852; FAX: (708) 252-7852; e-mail: lusk@mcs.anl.gov
D. Ashton: (630) 252-3336; e-mail: ashton@mcs.anl.gov
Mathematics and Computer Science Division
Argonne National Laboratory, Argonne IL 60439

Mississippi State Group
N. Doss:  (601) 325-2565; FAX: (601) 325-7692; e-mail: doss@erc.msstate.edu
A. Skjellum:(601) 325-8435; FAX: (601) 325-8997; e-mail: tony@erc.msstate.edu
Mississippi State University, Computer Science Department &
 NSF Engineering Research Center for Computational Field Simulation
P.O. Box 6176, Mississippi State MS 39762

			      GOVERNMENT LICENSE

Portions of this material resulted from work developed under a U.S.
Government Contract and are subject to the following license: the Government
is granted for itself and others acting on its behalf a paid-up, nonexclusive,
irrevocable worldwide license in this computer software to reproduce, prepare
derivative works, and perform publicly and display publicly.

				  DISCLAIMER

This computer code material was prepared, in part, as an account of work
sponsored by an agency of the United States Government.  Neither the United
States, nor the University of Chicago, nor Mississippi State University, nor
any of their employees, makes any warranty express or implied, or assumes any
legal liability or responsibility for the accuracy, completeness, or
usefulness of any information, apparatus, product, or process disclosed, or
represents that its use would not infringe privately owned rights.
*)
(* Porting to FreePascal by Avva, 2005 *)
interface

{$PACKRECORDS C}

{$ifndef _MPI_INCLUDE}
{$define _MPI_INCLUDE}

const
   MPI_MAX_PORT_NAME = 256;
{$define NEW_POINTERS}
   MPI_IDENT = 0;
   MPI_CONGRUENT = 1;
   MPI_SIMILAR = 2;
   MPI_UNEQUAL = 3;
type
   MPI_Datatype = longint;
type
   MPI_Errhandler = longint;
type
//   MPI_Request = MPIR_HANDLE;
   MPI_Request = longint;
   
function MPI_CHAR : MPI_Datatype;
function MPI_UNSIGNED_CHAR : MPI_Datatype;
function MPI_BYTE : MPI_Datatype;
function MPI_SHORT : MPI_Datatype;
function MPI_UNSIGNED_SHORT : MPI_Datatype;
function MPI_INT : MPI_Datatype;
function MPI_UNSIGNED : MPI_Datatype;
function MPI_LONG : MPI_Datatype;
function MPI_UNSIGNED_LONG : MPI_Datatype;
function MPI_FLOAT : MPI_Datatype;
function MPI_DOUBLE : MPI_Datatype;
function MPI_LONG_DOUBLE : MPI_Datatype;
function MPI_LONG_LONG_INT : MPI_Datatype;
function MPI_LONG_LONG : MPI_Datatype;
function MPI_PACKED : MPI_Datatype;
function MPI_LB : MPI_Datatype;
function MPI_UB : MPI_Datatype;
function MPI_FLOAT_INT : MPI_Datatype;
function MPI_DOUBLE_INT : MPI_Datatype;
function MPI_LONG_INT : MPI_Datatype;
function MPI_SHORT_INT : MPI_Datatype;
function MPI_2INT : MPI_Datatype;
function MPI_LONG_DOUBLE_INT : MPI_Datatype;
function MPI_COMPLEX : MPI_Datatype;
function MPI_DOUBLE_COMPLEX : MPI_Datatype;
function MPI_LOGICAL : MPI_Datatype;
function MPI_REAL : MPI_Datatype;
function MPI_DOUBLE_PRECISION : MPI_Datatype;
function MPI_INTEGER : MPI_Datatype;
function MPI_2INTEGER : MPI_Datatype;
function MPI_2COMPLEX : MPI_Datatype;
function MPI_2DOUBLE_COMPLEX : MPI_Datatype;
function MPI_2REAL : MPI_Datatype;
function MPI_2DOUBLE_PRECISION : MPI_Datatype;
function MPI_CHARACTER : MPI_Datatype;

type
   MPI_Comm = longint;
   MPI_Group = longint;
   MPI_Op = longint;
   
const
   MPI_COMM_WORLD = 91;
   MPI_COMM_SELF = 92;
   MPI_GROUP_EMPTY = 90;

function MPI_MAX : MPI_Op;
function MPI_MIN : MPI_Op;
function MPI_SUM : MPI_Op;
function MPI_PROD : MPI_Op;
function MPI_LAND : MPI_Op;
function MPI_BAND : MPI_Op;
function MPI_LOR : MPI_Op;
function MPI_BOR : MPI_Op;
function MPI_LXOR : MPI_Op;
function MPI_BXOR : MPI_Op;
function MPI_MINLOC : MPI_Op;
function MPI_MAXLOC : MPI_Op;

const
   MPI_TAG_UB = 81;
   MPI_HOST = 83;
   MPI_IO = 85;
   MPI_WTIME_IS_GLOBAL = 87;
   MPIR_TAG_UB = 80;
   MPIR_HOST = 82;
   MPIR_IO = 84;
   MPIR_WTIME_IS_GLOBAL = 86;
   
function MPI_COMM_NULL : MPI_Comm;
function MPI_OP_NULL : MPI_Op;
function MPI_GROUP_NULL : MPI_Group;
function MPI_DATATYPE_NULL : MPI_Datatype;
function MPI_REQUEST_NULL : MPI_Request;
function MPI_ERRHANDLER_NULL : MPI_Errhandler;

const
   MPI_MAX_PROCESSOR_NAME = 256;
   MPI_MAX_ERROR_STRING = 512;
   MPI_MAX_NAME_STRING = 63;
   MPI_UNDEFINED = -(32766);
   MPI_UNDEFINED_RANK = MPI_UNDEFINED;
   MPI_KEYVAL_INVALID = 0;
   MPI_BSEND_OVERHEAD = 512;
   MPI_GRAPH = 1;
   MPI_CART = 2;
   
function MPI_BOTTOM : pointer;

const
   MPI_PROC_NULL = -(1);
   MPI_ANY_SOURCE = -(2);
   MPI_ROOT = -(3);
   MPI_ANY_TAG = -(1);
   
type MPI_Handler_function = procedure();

function MPI_ERRORS_ARE_FATAL : MPI_Errhandler;
function MPI_ERRORS_RETURN : MPI_Errhandler;
function MPIR_ERRORS_WARN : MPI_Errhandler;

{
function MPI_NULL_COPY_FN;cdecl;external 'mpich.dll' name 'MPIR_null_copy_fn';
function MPI_NULL_DELETE_FN; 'MPIR_null_delete_fn';
function MPI_DUP_FN;cdecl;external 'mpich.dll' name 'MPIR_dup_fn';
function MPI_COMM_NULL_COPY_FN;cdecl;external 'mpich.dll' name 'MPI_NULL_COPY_FN';
function MPI_COMM_NULL_DELETE_FN;cdecl;external 'mpich.dll' name 'MPI_NULL_DELETE_FN';
function MPI_COMM_DUP_FN;cdecl;external 'mpich.dll' name 'MPI_DUP_FN';
}

// User combination function
//typedef void (MPI_User_function) ( void *, void *, int *, MPI_Datatype * );
type MPI_User_function = procedure( _para1 : pointer; _para2 : pointer; var _para3 : longint; var _para4 : MPI_Datatype);

// MPI Attribute copy and delete functions
//typedef int (MPI_Copy_function) ( MPI_Comm, int, void *, void *, void *, int * );
type MPI_Copy_function = procedure( _para1 :  MPI_Comm; _para2 : longint; _para3 : pointer; _para4 : pointer; _para5 : pointer; var _para6 : longint);
//typedef int (MPI_Delete_function) ( MPI_Comm, int, void *, void * );
type MPI_Delete_function = procedure( _para1 :  MPI_Comm; _para2 : longint; _para3 : pointer; _para4 : pointer);

const
   MPI_VERSION = 1;
   MPI_SUBVERSION = 2;
   MPICH_NAME = 1;
   MPICH_VERSION = '1.2.5';
{$define MPICH_HAS_C2F}
   MPI_COMBINER_NAMED = 2312;
   MPI_COMBINER_CONTIGUOUS = 2313;
   MPI_COMBINER_VECTOR = 2314;
   MPI_COMBINER_HVECTOR = 2315;
   MPI_COMBINER_INDEXED = 2316;
   MPI_COMBINER_HINDEXED = 2317;
   MPI_COMBINER_STRUCT = 2318;
type
//   MPI_Info = MPIR_Info;
   MPI_Info = longint;
   
function MPI_INFO_NULL : MPI_Info;

const
   MPI_MAX_INFO_KEY = 255;
   MPI_MAX_INFO_VAL = 1024;
   MPI_ORDER_C = 56;
   MPI_ORDER_FORTRAN = 57;
   MPI_DISTRIBUTE_BLOCK = 121;
   MPI_DISTRIBUTE_CYCLIC = 122;
   MPI_DISTRIBUTE_NONE = 123;
   MPI_DISTRIBUTE_DFLT_DARG = -(49767);

{$ifndef MPIDEFS_H}
{$define MPIDEFS_H}

const
   CONFIGURE_ARGS_CLEAN = 'the default Windows settings';
   MPIR_MAX_DATATYPE_ARRAY = 256;
{$define MPIR_HAS_COOKIES}
{$define HAVE_MPI_F2C}
   MPI_STATUS_SIZE = 4;
{$if (MPI_STATUS_SIZE > 4)}
{$endif}
type

   MPI_Status = record
        count : longint;
        MPI_SOURCE : longint;
        MPI_TAG : longint;
        MPI_ERROR : longint;
//        extra : array[0..(MPI_STATUS_SIZE - 4)-1] of longint;
     end;
// added by AvvA for MPI_Group_range_incl and MPI_Group_range_excl functions
  MPI_Triplet_range = packed record
        first, last, step : longint; 
     end;
{$define HAVE_BNR_CALL}
{$define HAVE_BNR_FUNCTION_POINTERS}
{$define HAVE_WINSOCK2_H}
{$ifndef HAVE_WINDOWS_H}
{$define HAVE_WINDOWS_H}
{$endif}
{$undef ANSI_ARGS}
function ANSI_ARGS(a : longint) : longint;

type
   MPI_Aint = longint;
   MPI_Fint = longint;
{$ifndef HAVE_INT64}
{$define HAVE_INT64}
{$endif}

{$ifndef ROMIO_NTFS}
{$define ROMIO_NTFS}
{$endif}


{$ifndef MPIO_INCLUDE}
{$define MPIO_INCLUDE}

const
   ROMIO_VERSION = 102;
type
//   MPI_File = ADIOI_FileD;
//   MPIO_Request = ADIOI_RequestD;
   MPI_File = longint;
   MPIO_Request = longint;

{$ifdef ROMIO_NTFS}
type
   MPI_Offset = int64;
{$endif}

{$ifdef NEEDS_MPI_FINT}
type
   MPI_Fint = longint;
{$endif}

{$ifndef HAVE_MPI_INFO}
{$define HAVE_MPI_INFO}
{$endif}

{$ifndef HAVE_MPI_INFO}
type
   MPI_Info = MPIR_Info;
   
function MPI_INFO_NULL : MPI_Info;

const
   MPI_MAX_INFO_KEY = 255;
   MPI_MAX_INFO_VAL = 1024;
{$endif}

const
   MPI_MODE_RDONLY = 2;
   MPI_MODE_RDWR = 8;
   MPI_MODE_WRONLY = 4;
   MPI_MODE_CREATE = 1;
   MPI_MODE_EXCL = 64;
   MPI_MODE_DELETE_ON_CLOSE = 16;
   MPI_MODE_UNIQUE_OPEN = 32;
   MPI_MODE_APPEND = 128;
   MPI_MODE_SEQUENTIAL = 256;
   MPI_DISPLACEMENT_CURRENT = -(54278278);
   
function MPI_FILE_NULL : MPI_File;

function MPIO_REQUEST_NULL : MPIO_Request;

const
   MPI_SEEK_SET = 600;
   MPI_SEEK_CUR = 602;
   MPI_SEEK_END = 604;
   MPI_MAX_DATAREP_STRING = 128;
{$ifndef HAVE_MPI_DARRAY_SUBARRAY}
{$define HAVE_MPI_DARRAY_SUBARRAY}
{$endif}
{$ifndef HAVE_MPI_DARRAY_SUBARRAY}

const
   MPI_ORDER_C = 56;
   MPI_ORDER_FORTRAN = 57;
   MPI_DISTRIBUTE_BLOCK = 121;
   MPI_DISTRIBUTE_CYCLIC = 122;
   MPI_DISTRIBUTE_NONE = 123;
   MPI_DISTRIBUTE_DFLT_DARG = -(49767);
{$endif}
{$ifndef HAVE_PRAGMA_HP_SEC_DEF}

function MPI_File_open(comm : MPI_Comm; filename : Pchar; amode : longint; info : MPI_Info; var fh : MPI_File) : longint;cdecl;external 'mpich.dll' name 'MPI_File_open';
function MPI_File_close(var fh : MPI_File) : longint;cdecl;external 'mpich.dll' name 'MPI_File_close';
function MPI_File_delete(filename : Pchar; info : MPI_Info) : longint;cdecl;external 'mpich.dll' name 'MPI_File_delete';
function MPI_File_set_size(fh : MPI_File; size : MPI_Offset) : longint;cdecl;external 'mpich.dll' name 'MPI_File_set_size';
function MPI_File_preallocate(fh : MPI_File; size : MPI_Offset) : longint;cdecl;external 'mpich.dll' name 'MPI_File_preallocate';
function MPI_File_get_size(fh : MPI_File; var size : MPI_Offset) : longint;cdecl;external 'mpich.dll' name 'MPI_File_get_size';
function MPI_File_get_group(fh : MPI_File; var group : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'MPI_File_get_group';
function MPI_File_get_amode(fh : MPI_File; var amode : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_File_get_amode';
function MPI_File_set_info(fh : MPI_File; info : MPI_Info) : longint;cdecl;external 'mpich.dll' name 'MPI_File_set_info';
function MPI_File_get_info(fh : MPI_File; var info_used : MPI_Info) : longint;cdecl;external 'mpich.dll' name 'MPI_File_get_info';
function MPI_File_set_view(fh : MPI_File; disp : MPI_Offset; etype : MPI_Datatype; filetype : MPI_Datatype; datarep : Pchar;
           info : MPI_Info) : longint;cdecl;external 'mpich.dll' name 'MPI_File_set_view';
function MPI_File_get_view(fh : MPI_File; var disp : MPI_Offset; var etype : MPI_Datatype; var filetype : MPI_Datatype; datarep : Pchar) : longint;cdecl;external 'mpich.dll' name 'MPI_File_get_view';
function MPI_File_read_at(fh : MPI_File; offset : MPI_Offset; buf : pointer; count : longint; datatype : MPI_Datatype;
           var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_read_at';
function MPI_File_read_at_all(fh : MPI_File; offset : MPI_Offset; buf : pointer; count : longint; datatype : MPI_Datatype;
           var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_read_at_all';
function MPI_File_write_at(fh : MPI_File; offset : MPI_Offset; buf : pointer; count : longint; datatype : MPI_Datatype;
           var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_write_at';
function MPI_File_write_at_all(fh : MPI_File; offset : MPI_Offset; buf : pointer; count : longint; datatype : MPI_Datatype;
           var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_write_at_all';
function MPI_File_iread_at(fh : MPI_File; offset : MPI_Offset; buf : pointer; count : longint; datatype : MPI_Datatype;
           var request : MPIO_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_File_iread_at';
function MPI_File_iwrite_at(fh : MPI_File; offset : MPI_Offset; buf : pointer; count : longint; datatype : MPI_Datatype;
           var request : MPIO_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_File_iwrite_at';
function MPI_File_read(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_read';
function MPI_File_read_all(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_read_all';
function MPI_File_write(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_write';
function MPI_File_write_all(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_write_all';
function MPI_File_iread(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var request : MPIO_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_File_iread';
function MPI_File_iwrite(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var request : MPIO_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_File_iwrite';
function MPI_File_seek(fh : MPI_File; offset : MPI_Offset; whence : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_File_seek';
function MPI_File_get_position(fh : MPI_File;var offset : MPI_Offset) : longint;cdecl;external 'mpich.dll' name 'MPI_File_get_position';
function MPI_File_get_byte_offset(fh : MPI_File; offset : MPI_Offset; var disp : MPI_Offset) : longint;cdecl;external 'mpich.dll' name 'MPI_File_get_byte_offset';
function MPI_File_read_shared(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_read_shared';
function MPI_File_write_shared(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_write_shared';
function MPI_File_iread_shared(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var request : MPIO_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_File_iread_shared';
function MPI_File_iwrite_shared(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var request : MPIO_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_File_iwrite_shared';
function MPI_File_read_ordered(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_read_ordered';
function MPI_File_write_ordered(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_write_ordered';
function MPI_File_seek_shared(fh : MPI_File; offset : MPI_Offset; whence : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_File_seek_shared';
function MPI_File_get_position_shared(fh : MPI_File; var offset : MPI_Offset) : longint;cdecl;external 'mpich.dll' name 'MPI_File_get_position_shared';
function MPI_File_read_at_all_begin(fh : MPI_File; offset : MPI_Offset; buf : pointer; count : longint; datatype : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_File_read_at_all_begin';
function MPI_File_read_at_all_end(fh : MPI_File; buf : pointer; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_read_at_all_end';
function MPI_File_write_at_all_begin(fh : MPI_File; offset : MPI_Offset; buf : pointer; count : longint; datatype : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_File_write_at_all_begin';
function MPI_File_write_at_all_end(fh : MPI_File; buf : pointer; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_write_at_all_end';
function MPI_File_read_all_begin(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_File_read_all_begin';
function MPI_File_read_all_end(fh : MPI_File; buf : pointer; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_read_all_end';
function MPI_File_write_all_begin(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_File_write_all_begin';
function MPI_File_write_all_end(fh : MPI_File; buf : pointer; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_write_all_end';
function MPI_File_read_ordered_begin(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_File_read_ordered_begin';
function MPI_File_read_ordered_end(fh : MPI_File; buf : pointer; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_read_ordered_end';
function MPI_File_write_ordered_begin(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_File_write_ordered_begin';
function MPI_File_write_ordered_end(fh : MPI_File; buf : pointer; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_File_write_ordered_end';
function MPI_File_get_type_extent(fh : MPI_File; datatype : MPI_Datatype; var extent : MPI_Aint) : longint;cdecl;external 'mpich.dll' name 'MPI_File_get_type_extent';
function MPI_File_set_atomicity(fh : MPI_File; flag : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_File_set_atomicity';
function MPI_File_get_atomicity(fh : MPI_File; var flag : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_File_get_atomicity';
function MPI_File_sync(fh : MPI_File) : longint;cdecl;external 'mpich.dll' name 'MPI_File_sync';
{$ifndef HAVE_MPI_DARRAY_SUBARRAY}

function MPI_Type_create_subarray(ndims : longint; array_of_sizes : Plongint; array_of_subsizes : Plongint; array_of_starts : Plongint; order : longint;
           oldtype : MPI_Datatype; newtype : PMPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_create_subarray';
function MPI_Type_create_darray(size : longint; rank : longint; ndims : longint; array_of_gsizes : Plongint; array_of_distribs : Plongint;
           array_of_dargs : Plongint; array_of_psizes : Plongint; order : longint; oldtype : MPI_Datatype; newtype : PMPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_create_darray';
{$endif}
{$ifdef MPI_File_f2c}
{$undef MPI_File_f2c}
{$endif}
{$ifdef MPI_File_c2f}
{$undef MPI_File_c2f}
{$endif}

function MPI_File_f2c(fh : MPI_Fint) : MPI_File;cdecl;external 'mpich.dll' name 'MPI_File_f2c';
function MPI_File_c2f(fh : MPI_File) : MPI_Fint;cdecl;external 'mpich.dll' name 'MPI_File_c2f';
function MPIO_Test(var request : MPIO_Request; var flag : longint; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPIO_Test';
function MPIO_Wait(var request : MPIO_Request; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPIO_Wait';
//function MPIO_Request_c2f(request : MPIO_Request) : MPI_Fint;cdecl;external 'mpich.dll' name 'MPIO_Request_c2f';
//function MPIO_Request_f2c(request : MPI_Fint) : MPIO_Request;cdecl;external 'mpich.dll' name 'MPIO_Request_f2c';
{$ifndef HAVE_MPI_INFO}

function MPI_Info_create(info : PMPI_Info) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_create';
function MPI_Info_set(info : MPI_Info; key : Pchar; value : Pchar) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_set';
function MPI_Info_delete(info : MPI_Info; key : Pchar) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_delete';
function MPI_Info_get(info : MPI_Info; key : Pchar; valuelen : longint; value : Pchar; var flag : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_get';
function MPI_Info_get_valuelen(info : MPI_Info; key : Pchar; valuelen : Plongint; var flag : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_get_valuelen';
function MPI_Info_get_nkeys(info : MPI_Info; nkeys : Plongint) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_get_nkeys';
function MPI_Info_get_nthkey(info : MPI_Info; n : longint; key : Pchar) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_get_nthkey';
function MPI_Info_dup(info : MPI_Info; newinfo : PMPI_Info) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_dup';
function MPI_Info_free(info : PMPI_Info) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_free';
{$ifdef MPI_Info_f2c}
{$undef MPI_Info_f2c}
{$endif}
{$ifdef MPI_Info_c2f}
{$undef MPI_Info_c2f}
{$endif}

//function MPI_Info_c2f(info : MPI_Info) : MPI_Fint;cdecl;external 'mpich.dll' name 'MPI_Info_c2f';
//function MPI_Info_f2c(info : MPI_Fint) : MPI_Info;cdecl;external 'mpich.dll' name 'MPI_Info_f2c';
{$endif}
{$endif}

function PMPI_File_open(comm : MPI_Comm; filename : Pchar; amode : longint; info : MPI_Info; var fh : MPI_File) : longint;cdecl;external 'mpich.dll' name 'MPI_File_open';
function PMPI_File_close(var fh : MPI_File) : longint;cdecl;external 'mpich.dll' name 'MPI_File_close';
function PMPI_File_delete(filename : Pchar; info : MPI_Info) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_delete';
function PMPI_File_set_size(fh : MPI_File; size : MPI_Offset) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_set_size';
function PMPI_File_preallocate(fh : MPI_File; size : MPI_Offset) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_preallocate';
function PMPI_File_get_size(fh : MPI_File; var size : MPI_Offset) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_get_size';
function PMPI_File_get_group(fh : MPI_File; var group : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_get_group';
function PMPI_File_get_amode(fh : MPI_File; amode : Plongint) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_get_amode';
function PMPI_File_set_info(fh : MPI_File; info : MPI_Info) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_set_info';
function PMPI_File_get_info(fh : MPI_File; var info_used : MPI_Info) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_get_info';
function PMPI_File_set_view(fh : MPI_File; disp : MPI_Offset; etype : MPI_Datatype; filetype : MPI_Datatype; datarep : Pchar;
           info : MPI_Info) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_set_view';
function PMPI_File_get_view(fh : MPI_File; var disp : MPI_Offset; var etype : MPI_Datatype; var filetype : MPI_Datatype; datarep : Pchar) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_get_view';
function PMPI_File_read_at(fh : MPI_File; offset : MPI_Offset; buf : pointer; count : longint; datatype : MPI_Datatype;
           var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_read_at';
function PMPI_File_read_at_all(fh : MPI_File; offset : MPI_Offset; buf : pointer; count : longint; datatype : MPI_Datatype;
           var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_read_at_all';
function PMPI_File_write_at(fh : MPI_File; offset : MPI_Offset; buf : pointer; count : longint; datatype : MPI_Datatype;
           var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_write_at';
function PMPI_File_write_at_all(fh : MPI_File; offset : MPI_Offset; buf : pointer; count : longint; datatype : MPI_Datatype;
           var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_write_at_all';
function PMPI_File_iread_at(fh : MPI_File; offset : MPI_Offset; buf : pointer; count : longint; datatype : MPI_Datatype;
           var request : MPIO_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_iread_at';
function PMPI_File_iwrite_at(fh : MPI_File; offset : MPI_Offset; buf : pointer; count : longint; datatype : MPI_Datatype;
           var request : MPIO_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_iwrite_at';
function PMPI_File_read(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_read';
function PMPI_File_read_all(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_read_all';
function PMPI_File_write(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_write';
function PMPI_File_write_all(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_write_all';
function PMPI_File_iread(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var request : MPIO_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_iread';
function PMPI_File_iwrite(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var request : MPIO_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_iwrite';
function PMPI_File_seek(fh : MPI_File; offset : MPI_Offset; whence : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_seek';
function PMPI_File_get_position(fh : MPI_File; var offset : MPI_Offset) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_get_position';
function PMPI_File_get_byte_offset(fh : MPI_File; offset : MPI_Offset; var disp : MPI_Offset) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_get_byte_offset';
function PMPI_File_read_shared(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_read_shared';
function PMPI_File_write_shared(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_write_shared';
function PMPI_File_iread_shared(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var request : MPIO_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_iread_shared';
function PMPI_File_iwrite_shared(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var request : MPIO_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_iwrite_shared';
function PMPI_File_read_ordered(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_read_ordered';
function PMPI_File_write_ordered(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_write_ordered';
function PMPI_File_seek_shared(fh : MPI_File; offset : MPI_Offset; whence : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_seek_shared';
function PMPI_File_get_position_shared(fh : MPI_File; var offset : MPI_Offset) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_get_position_shared';
function PMPI_File_read_at_all_begin(fh : MPI_File; offset : MPI_Offset; buf : pointer; count : longint; datatype : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_read_at_all_begin';
function PMPI_File_read_at_all_end(fh : MPI_File; buf : pointer; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_read_at_all_end';
function PMPI_File_write_at_all_begin(fh : MPI_File; offset : MPI_Offset; buf : pointer; count : longint; datatype : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_write_at_all_begin';
function PMPI_File_write_at_all_end(fh : MPI_File; buf : pointer; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_write_at_all_end';
function PMPI_File_read_all_begin(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_read_all_begin';
function PMPI_File_read_all_end(fh : MPI_File; buf : pointer; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_read_all_end';
function PMPI_File_write_all_begin(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_write_all_begin';
function PMPI_File_write_all_end(fh : MPI_File; buf : pointer; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_write_all_end';
function PMPI_File_read_ordered_begin(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_read_ordered_begin';
function PMPI_File_read_ordered_end(fh : MPI_File; buf : pointer; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_read_ordered_end';
function PMPI_File_write_ordered_begin(fh : MPI_File; buf : pointer; count : longint; datatype : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_write_ordered_begin';
function PMPI_File_write_ordered_end(fh : MPI_File; buf : pointer; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_write_ordered_end';
function PMPI_File_get_type_extent(fh : MPI_File; datatype : MPI_Datatype; var extent : MPI_Aint) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_get_type_extent';
function PMPI_File_set_atomicity(fh : MPI_File; flag : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_set_atomicity';
function PMPI_File_get_atomicity(fh : MPI_File; var flag : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_get_atomicity';
function PMPI_File_sync(fh : MPI_File) : longint;cdecl;external 'mpich.dll' name 'PMPI_File_sync';
{$ifndef HAVE_MPI_DARRAY_SUBARRAY}

function PMPI_Type_create_subarray(ndims : longint; array_of_sizes : Plongint; array_of_subsizes : Plongint; array_of_starts : Plongint; order : longint;
           oldtype : MPI_Datatype; newtype : PMPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_create_subarray';
function PMPI_Type_create_darray(size : longint; rank : longint; ndims : longint; array_of_gsizes : Plongint; array_of_distribs : Plongint;
           array_of_dargs : Plongint; array_of_psizes : Plongint; order : longint; oldtype : MPI_Datatype; newtype : PMPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_create_darray';
{$endif}

function PMPI_File_f2c(fh : MPI_Fint) : MPI_File;cdecl;external 'mpich.dll' name 'PMPI_File_f2c';
function PMPI_File_c2f(fh : MPI_File) : MPI_Fint;cdecl;external 'mpich.dll' name 'PMPI_File_c2f';
//function MPI_File_set_errhandler(fh : MPI_File; errhandler : MPI_Errhandler) : longint;cdecl;external 'mpich.dll' name 'MPI_File_set_errhandler';
//function MPI_File_get_errhandler(fh : MPI_File; var errhandler : MPI_Errhandler) : longint;cdecl;external 'mpich.dll' name 'MPI_File_get_errhandler';
function PMPIO_Test(var request : MPIO_Request; var flag : longint; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPIO_Test';
function PMPIO_Wait(var request : MPIO_Request; var status : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPIO_Wait';
//function PMPIO_Request_c2f(request : MPIO_Request) : MPI_Fint;cdecl;external 'mpich.dll' name 'PMPIO_Request_c2f';
//function PMPIO_Request_f2c(request : MPI_Fint) : MPIO_Request;cdecl;external 'mpich.dll' name 'PMPIO_Request_f2c';
{$ifndef HAVE_MPI_INFO}

function PMPI_Info_create(info : PMPI_Info) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_create';
function PMPI_Info_set(info : MPI_Info; key : Pchar; value : Pchar) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_set';
function PMPI_Info_delete(info : MPI_Info; key : Pchar) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_delete';
function PMPI_Info_get(info : MPI_Info; key : Pchar; valuelen : longint; value : Pchar; var flag : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_get';
function PMPI_Info_get_valuelen(info : MPI_Info; key : Pchar; valuelen : Plongint; var flag : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_get_valuelen';
function PMPI_Info_get_nkeys(info : MPI_Info; nkeys : Plongint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_get_nkeys';
function PMPI_Info_get_nthkey(info : MPI_Info; n : longint; key : Pchar) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_get_nthkey';
function PMPI_Info_dup(info : MPI_Info; newinfo : PMPI_Info) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_dup';
function PMPI_Info_free(info : PMPI_Info) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_free';
function PMPI_Info_c2f(info : MPI_Info) : MPI_Fint;cdecl;external 'mpich.dll' name 'PMPI_Info_c2f';
function PMPI_Info_f2c(info : MPI_Fint) : MPI_Info;cdecl;external 'mpich.dll' name 'PMPI_Info_f2c';
{$endif}
{$endif}

{$endif}

function MPI_Comm_c2f(comm : longint) : MPI_Fint;
function MPI_Comm_f2c(comm : longint) : MPI_Comm;
function MPI_Type_c2f(datatype : longint) : MPI_Fint;
function MPI_Type_f2c(datatype : longint) : MPI_Datatype;
function MPI_Group_c2f(group : longint) : MPI_Fint;
function MPI_Group_f2c(group : longint) : MPI_Group;
function MPI_Request_f2c(request : longint) : MPI_Request;
function MPI_Op_c2f(op : longint) : MPI_Fint;
function MPI_Op_f2c(op : longint) : MPI_Op;
function MPI_Errhandler_c2f(errhandler : longint) : MPI_Fint;
function MPI_Errhandler_f2c(errhandler : longint) : MPI_Errhandler;
function MPI_Win_c2f(win : longint) : MPI_Fint;
{
function MPI_Win_f2c(win : longint) : MPI_Win;
function MPI_STATUS_IGNORE : ^MPI_Status;
function MPI_STATUSES_IGNORE : ^MPI_Status;
}

const
   MPI_THREAD_SINGLE = 0;
   MPI_THREAD_FUNNELED = 1;
   MPI_THREAD_SERIALIZED = 2;
   MPI_THREAD_MULTIPLE = 3;
  var
     MPICHX_QOS_BANDWIDTH : longint;cvar;external;
     MPICHX_QOS_PARAMETERS : longint;cvar;external;
     MPICHX_TOPOLOGY_DEPTHS : longint;cvar;external;
     MPICHX_TOPOLOGY_COLORS : longint;cvar;external;

const
   MPICHX_WAN_LEVEL = 0;
   MPICHX_LAN_LEVEL = 1;
   MPICHX_HOST_LEVEL = 2;
   MPICHX_VMPI_LEVEL = 3;
  var
     MPICHX_PARALLELSOCKETS_PARAMETERS : longint;cvar;external;
type
   gridftp_params = record
        partner_rank : longint;
        nsocket_pairs : longint;
        max_outstanding_writes : longint;
        tcp_buffsize : longint;
     end;


{$ifndef MPI_SUCCESS}

const
   MPI_SUCCESS = 0;
   MPI_ERR_BUFFER = 1;
   MPI_ERR_COUNT = 2;
   MPI_ERR_TYPE = 3;
   MPI_ERR_TAG = 4;
   MPI_ERR_COMM = 5;
   MPI_ERR_RANK = 6;
   MPI_ERR_ROOT = 7;
   MPI_ERR_TRUNCATE = 14;
   MPI_ERR_GROUP = 8;
   MPI_ERR_OP = 9;
   MPI_ERR_REQUEST = 19;
   MPI_ERR_TOPOLOGY = 10;
   MPI_ERR_DIMS = 11;
   MPI_ERR_ARG = 12;
   MPI_ERR_OTHER = 15;
   MPI_ERR_UNKNOWN = 13;
   MPI_ERR_INTERN = 16;
   MPI_ERR_IN_STATUS = 17;
   MPI_ERR_PENDING = 18;
   MPI_ERR_FILE = 27;
   MPI_ERR_ACCESS = 20;
   MPI_ERR_AMODE = 21;
   MPI_ERR_BAD_FILE = 22;
   MPI_ERR_FILE_EXISTS = 25;
   MPI_ERR_FILE_IN_USE = 26;
   MPI_ERR_NO_SPACE = 36;
   MPI_ERR_NO_SUCH_FILE = 37;
   MPI_ERR_IO = 32;
   MPI_ERR_READ_ONLY = 40;
   MPI_ERR_CONVERSION = 23;
   MPI_ERR_DUP_DATAREP = 24;
   MPI_ERR_UNSUPPORTED_DATAREP = 43;
   MPI_ERR_INFO = 28;
   MPI_ERR_INFO_KEY = 29;
   MPI_ERR_INFO_VALUE = 30;
   MPI_ERR_INFO_NOKEY = 31;
   MPI_ERR_NAME = 33;
   MPI_ERR_NO_MEM = 34;
   MPI_ERR_NOT_SAME = 35;
   MPI_ERR_PORT = 38;
   MPI_ERR_QUOTA = 39;
   MPI_ERR_SERVICE = 41;
   MPI_ERR_SPAWN = 42;
   MPI_ERR_UNSUPPORTED_OPERATION = 44;
   MPI_ERR_WIN = 45;
   MPI_ERR_LASTCODE = $3FFFFFFF;
{$endif}

{$ifndef MPICH_SUPPRESS_PROTOTYPES}

function MPI_Send(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Send';
function MPI_Recv(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_Recv';
function MPI_Get_count(var _para1 : MPI_Status; _para2 : MPI_Datatype; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Get_count';
function MPI_Bsend(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Bsend';
function MPI_Ssend(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Ssend';
function MPI_Rsend(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Rsend';
function MPI_Buffer_attach(_para1 : pointer; _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Buffer_attach';
function MPI_Buffer_detach(_para1 : pointer; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Buffer_detach';
function MPI_Isend(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_Isend';
function MPI_Ibsend(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_Ibsend';
function MPI_Issend(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_Issend';
function MPI_Irsend(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_Irsend';
function MPI_Irecv(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_Irecv';
function MPI_Wait(var _para1 : MPI_Request; var _para2 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_Wait';
function MPI_Test(var _para1 : MPI_Request; var _para2 : longint; var _para3 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_Test';
function MPI_Request_free(var _para1 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_Request_free';
function MPI_Waitany(_para1 : longint; var _para2 : MPI_Request; var _para3 : longint; var _para4 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_Waitany';
function MPI_Testany(_para1 : longint; var _para2 : MPI_Request; var _para3 : longint; var _para4 : longint; var _para5 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_Testany';
function MPI_Waitall(_para1 : longint; var _para2 : MPI_Request; var _para3 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_Waitall';
function MPI_Testall(_para1 : longint; var _para2 : MPI_Request; var _para3 : longint; var _para4 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_Testall';
function MPI_Waitsome(_para1 : longint; var _para2 : MPI_Request; var _para3 : longint; var _para4 : longint; var _para5 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_Waitsome';
function MPI_Testsome(_para1 : longint; var _para2 : MPI_Request; var _para3 : longint; var _para4 : longint; var _para5 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_Testsome';
function MPI_Iprobe(_para1 : longint; _para2 : longint; _para3 : MPI_Comm; var flag : longint; var _para5 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_Iprobe';
function MPI_Probe(_para1 : longint; _para2 : longint; _para3 : MPI_Comm; var _para4 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_Probe';
function MPI_Cancel(var _para1 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_Cancel';
function MPI_Test_cancelled(var _para1 : MPI_Status; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Test_cancelled';
function MPI_Send_init(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_Send_init';
function MPI_Bsend_init(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_Bsend_init';
function MPI_Ssend_init(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_Ssend_init';
function MPI_Rsend_init(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_Rsend_init';
function MPI_Recv_init(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_Recv_init';
function MPI_Start(var _para1 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_Start';
function MPI_Startall(_para1 : longint; var _para2 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'MPI_Startall';
function MPI_Sendrecv(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : pointer; _para7 : longint; _para8 : MPI_Datatype; _para9 : longint; _para10 : longint;
           _para11 : MPI_Comm; var _para12 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_Sendrecv';
function MPI_Sendrecv_replace(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : longint; _para7 : longint; _para8 : MPI_Comm; var _para9 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_Sendrecv_replace';
function MPI_Type_contiguous(_para1 : longint; _para2 : MPI_Datatype; var _para3 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_contiguous';
function MPI_Type_vector(_para1 : longint; _para2 : longint; _para3 : longint; _para4 : MPI_Datatype; var _para5 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_vector';
function MPI_Type_hvector(_para1 : longint; _para2 : longint; _para3 : MPI_Aint; _para4 : MPI_Datatype; var _para5 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_hvector';
function MPI_Type_indexed(_para1 : longint; var _para2 : longint; var _para3 : longint; _para4 : MPI_Datatype; var _para5 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_indexed';
function MPI_Type_hindexed(_para1 : longint; var _para2 : longint; var _para3 : MPI_Aint; _para4 : MPI_Datatype; var _para5 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_hindexed';
function MPI_Type_struct(_para1 : longint; var _para2 : longint; var _para3 : MPI_Aint; var _para4 : MPI_Datatype; var _para5 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_struct';
function MPI_Address(_para1 : pointer; var _para2 : MPI_Aint) : longint;cdecl;external 'mpich.dll' name 'MPI_Address';
function MPI_Type_extent(_para1 : MPI_Datatype; var _para2 : MPI_Aint) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_extent';
function MPI_Type_size(_para1 : MPI_Datatype; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_size';
function MPI_Type_lb(_para1 : MPI_Datatype; var _para2 : MPI_Aint) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_lb';
function MPI_Type_ub(_para1 : MPI_Datatype; var _para2 : MPI_Aint) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_ub';
function MPI_Type_commit(var _para1 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_commit';
function MPI_Type_free(var _para1 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_free';
function MPI_Get_elements(var _para1 : MPI_Status; _para2 : MPI_Datatype; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Get_elements';
function MPI_Pack(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : pointer; _para5 : longint;
           var _para6 : longint; _para7 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Pack';
function MPI_Unpack(_para1 : pointer; _para2 : longint; var _para3 : longint; _para4 : pointer; _para5 : longint;
           _para6 : MPI_Datatype; _para7 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Unpack';
function MPI_Pack_size(_para1 : longint; _para2 : MPI_Datatype; _para3 : MPI_Comm; var _para4 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Pack_size';
function MPI_Barrier(_para1 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Barrier';
function MPI_Bcast(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Bcast';
function MPI_Gather(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : pointer; _para5 : longint;
           _para6 : MPI_Datatype; _para7 : longint; _para8 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Gather';
function MPI_Gatherv(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : pointer; var _para5 : longint;
           var _para6 : longint; _para7 : MPI_Datatype; _para8 : longint; _para9 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Gatherv';
function MPI_Scatter(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : pointer; _para5 : longint;
           _para6 : MPI_Datatype; _para7 : longint; _para8 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Scatter';
function MPI_Scatterv(_para1 : pointer; var _para2 : longint; var _para3 : longint; _para4 : MPI_Datatype; _para5 : pointer;
           _para6 : longint; _para7 : MPI_Datatype; _para8 : longint; _para9 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Scatterv';
function MPI_Allgather(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : pointer; _para5 : longint;
           _para6 : MPI_Datatype; _para7 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Allgather';
function MPI_Allgatherv(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : pointer; var _para5 : longint;
           var _para6 : longint; _para7 : MPI_Datatype; _para8 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Allgatherv';
function MPI_Alltoall(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : pointer; _para5 : longint;
           _para6 : MPI_Datatype; _para7 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Alltoall';
function MPI_Alltoallv(_para1 : pointer; var _para2 : longint; var _para3 : longint; _para4 : MPI_Datatype; _para5 : pointer;
           var _para6 : longint; var _para7 : longint; _para8 : MPI_Datatype; _para9 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Alltoallv';
function MPI_Reduce(_para1 : pointer; _para2 : pointer; _para3 : longint; _para4 : MPI_Datatype; _para5 : MPI_Op;
           _para6 : longint; _para7 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Reduce';
function MPI_Op_create(var _para1 : MPI_User_function; _para2 : longint; var _para3 : MPI_Op) : longint;cdecl;external 'mpich.dll' name 'MPI_Op_create';
function MPI_Op_free(var _para1 : MPI_Op) : longint;cdecl;external 'mpich.dll' name 'MPI_Op_free';
function MPI_Allreduce(_para1 : pointer; _para2 : pointer; _para3 : longint; _para4 : MPI_Datatype; _para5 : MPI_Op;
           _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Allreduce';
function MPI_Reduce_scatter(_para1 : pointer; _para2 : pointer; var _para3 : longint; _para4 : MPI_Datatype; _para5 : MPI_Op;
           _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Reduce_scatter';
function MPI_Scan(_para1 : pointer; _para2 : pointer; _para3 : longint; _para4 : MPI_Datatype; _para5 : MPI_Op;
           _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Scan';
function MPI_Group_size(group : MPI_Group; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Group_size';
function MPI_Group_rank(group : MPI_Group; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Group_rank';
function MPI_Group_translate_ranks(_para1 : MPI_Group; _para2 : longint; var _para3 : longint; _para4 : MPI_Group; var _para5 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Group_translate_ranks';
function MPI_Group_compare(_para1 : MPI_Group; _para2 : MPI_Group; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Group_compare';
function MPI_Comm_group(_para1 : MPI_Comm; var _para2 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'MPI_Comm_group';
function MPI_Group_union(_para1 : MPI_Group; _para2 : MPI_Group; var _para3 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'MPI_Group_union';
function MPI_Group_intersection(_para1 : MPI_Group; _para2 : MPI_Group; var _para3 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'MPI_Group_intersection';
function MPI_Group_difference(_para1 : MPI_Group; _para2 : MPI_Group; var _para3 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'MPI_Group_difference';
function MPI_Group_incl(group : MPI_Group; _para2 : longint; _para3 : plongint; var _para4 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'MPI_Group_incl';
function MPI_Group_excl(group : MPI_Group; _para2 : longint; _para3 : plongint; var _para4 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'MPI_Group_excl';
function MPI_Group_range_incl(group : MPI_Group; _para2 : longint; const _para3 : array of MPI_Triplet_range; var _para4 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'MPI_Group_range_incl';
function MPI_Group_range_excl(group : MPI_Group; _para2 : longint; const _para3 : array of MPI_Triplet_range; var _para4 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'MPI_Group_range_excl';
function MPI_Group_free(var _para1 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'MPI_Group_free';
function MPI_Comm_size(_para1 : MPI_Comm; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Comm_size';
function MPI_Comm_rank(_para1 : MPI_Comm; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Comm_rank';
function MPI_Comm_compare(_para1 : MPI_Comm; _para2 : MPI_Comm; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Comm_compare';
function MPI_Comm_dup(_para1 : MPI_Comm; var _para2 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Comm_dup';
function MPI_Comm_create(_para1 : MPI_Comm; _para2 : MPI_Group; var _para3 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Comm_create';
function MPI_Comm_split(_para1 : MPI_Comm; _para2 : longint; _para3 : longint; var _para4 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Comm_split';
function MPI_Comm_free(var _para1 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Comm_free';
function MPI_Comm_test_inter(_para1 : MPI_Comm; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Comm_test_inter';
function MPI_Comm_remote_size(_para1 : MPI_Comm; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Comm_remote_size';
function MPI_Comm_remote_group(_para1 : MPI_Comm; var _para2 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'MPI_Comm_remote_group';
function MPI_Intercomm_create(_para1 : MPI_Comm; _para2 : longint; _para3 : MPI_Comm; _para4 : longint; _para5 : longint;
           var _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Intercomm_create';
function MPI_Intercomm_merge(_para1 : MPI_Comm; _para2 : longint; var _para3 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Intercomm_merge';
function MPI_Keyval_create(var _para1 : MPI_Copy_function; var _para2 : MPI_Delete_function; var _para3 : longint; _para4 : pointer) : longint;cdecl;external 'mpich.dll' name 'MPI_Keyval_create';
function MPI_Keyval_free(var _para1 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Keyval_free';
function MPI_Attr_put(_para1 : MPI_Comm; _para2 : longint; _para3 : pointer) : longint;cdecl;external 'mpich.dll' name 'MPI_Attr_put';
function MPI_Attr_get(_para1 : MPI_Comm; _para2 : longint; _para3 : pointer; var _para4 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Attr_get';
function MPI_Attr_delete(_para1 : MPI_Comm; _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Attr_delete';
function MPI_Topo_test(_para1 : MPI_Comm; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Topo_test';
function MPI_Cart_create(_para1 : MPI_Comm; _para2 : longint; var _para3 : longint; var _para4 : longint; _para5 : longint;
           var _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Cart_create';
function MPI_Dims_create(_para1 : longint; _para2 : longint; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Dims_create';
function MPI_Graph_create(_para1 : MPI_Comm; _para2 : longint; var _para3 : longint; var _para4 : longint; _para5 : longint;
           var _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Graph_create';
function MPI_Graphdims_get(_para1 : MPI_Comm; var _para2 : longint; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Graphdims_get';
function MPI_Graph_get(_para1 : MPI_Comm; _para2 : longint; _para3 : longint; var _para4 : longint; var _para5 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Graph_get';
function MPI_Cartdim_get(_para1 : MPI_Comm; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Cartdim_get';
function MPI_Cart_get(_para1 : MPI_Comm; _para2 : longint; var _para3 : longint; var _para4 : longint; var _para5 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Cart_get';
function MPI_Cart_rank(_para1 : MPI_Comm; var _para2 : longint; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Cart_rank';
function MPI_Cart_coords(_para1 : MPI_Comm; _para2 : longint; _para3 : longint; var _para4 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Cart_coords';
function MPI_Graph_neighbors_count(_para1 : MPI_Comm; _para2 : longint; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Graph_neighbors_count';
function MPI_Graph_neighbors(_para1 : MPI_Comm; _para2 : longint; _para3 : longint; var _para4 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Graph_neighbors';
function MPI_Cart_shift(_para1 : MPI_Comm; _para2 : longint; _para3 : longint; var _para4 : longint; var _para5 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Cart_shift';
function MPI_Cart_sub(_para1 : MPI_Comm; var _para2 : longint; var _para3 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'MPI_Cart_sub';
function MPI_Cart_map(_para1 : MPI_Comm; _para2 : longint; var _para3 : longint; var _para4 : longint; var _para5 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Cart_map';
function MPI_Graph_map(_para1 : MPI_Comm; _para2 : longint; var _para3 : longint; var _para4 : longint; var _para5 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Graph_map';
function MPI_Get_processor_name(_para1 : Pchar; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Get_processor_name';
function MPI_Get_version(var _para1 : longint; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Get_version';
function MPI_Errhandler_create(var _para1 : MPI_Handler_function; var _para2 : MPI_Errhandler) : longint;cdecl;external 'mpich.dll' name 'MPI_Errhandler_create';
function MPI_Errhandler_set(_para1 : MPI_Comm; _para2 : MPI_Errhandler) : longint;cdecl;external 'mpich.dll' name 'MPI_Errhandler_set';
function MPI_Errhandler_get(_para1 : MPI_Comm; var _para2 : MPI_Errhandler) : longint;cdecl;external 'mpich.dll' name 'MPI_Errhandler_get';
function MPI_Errhandler_free(var _para1 : MPI_Errhandler) : longint;cdecl;external 'mpich.dll' name 'MPI_Errhandler_free';
function MPI_Error_string(_para1 : longint; _para2 : Pchar; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Error_string';
function MPI_Error_class(_para1 : longint; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Error_class';
function MPI_Wtime : double;cdecl;external 'mpich.dll' name 'MPI_Wtime';
function MPI_Wtick : double;cdecl;external 'mpich.dll' name 'MPI_Wtick';
{$ifndef MPI_Wtime}
function PMPI_Wtime : double;cdecl;external 'mpich.dll' name 'PMPI_Wtime';
function PMPI_Wtick : double;cdecl;external 'mpich.dll' name 'PMPI_Wtick';
{$endif}

function MPI_Init(var _para1 : longint; var _para2 : PPchar) : longint;cdecl;external 'mpich.dll' name 'MPI_Init';

function MPI_Init_thread(var _para1 : longint; var _para2 : PPchar; _para3 : longint; var _para4 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Init_thread';

function MPI_Finalize : longint;cdecl;external 'mpich.dll' name 'MPI_Finalize';
function MPI_Initialized(var _para1 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Initialized';
function MPI_Abort(_para1 : MPI_Comm; _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Abort';
function MPI_Comm_set_name(_para1 : MPI_Comm; _para2 : Pchar) : longint;cdecl;external 'mpich.dll' name 'MPI_Comm_set_name';
function MPI_Comm_get_name(_para1 : MPI_Comm; _para2 : Pchar; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Comm_get_name';

function MPI_Pcontrol(_para1 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Pcontrol';

function MPI_NULL_COPY_FN(_para1 : MPI_Comm; _para2 : longint; _para3 : pointer; _para4 : pointer; _para5 : pointer;
           var _para6 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_NULL_COPY_FN';
function MPI_NULL_DELETE_FN(_para1 : MPI_Comm; _para2 : longint; _para3 : pointer; _para4 : pointer) : longint;cdecl;external 'mpich.dll' name 'MPI_NULL_DELETE_FN';
function MPI_DUP_FN(_para1 : MPI_Comm; _para2 : longint; _para3 : pointer; _para4 : pointer; _para5 : pointer;
           var _para6 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_DUP_FN';
function MPI_Status_f2c(var _para1 : MPI_Fint; var _para2 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'MPI_Status_f2c';
function MPI_Status_c2f(var _para1 : MPI_Status; var _para2 : MPI_Fint) : longint;cdecl;external 'mpich.dll' name 'MPI_Status_c2f';
function MPI_Finalized(var _para1 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Finalized';
function MPI_Type_create_indexed_block(_para1 : longint; _para2 : longint; var _para3 : longint; _para4 : MPI_Datatype; var _para5 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_create_indexed_block';
function MPI_Type_get_envelope(_para1 : MPI_Datatype; var _para2 : longint; var _para3 : longint; var _para4 : longint; var _para5 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_get_envelope';
function MPI_Type_get_contents(_para1 : MPI_Datatype; _para2 : longint; _para3 : longint; _para4 : longint; var _para5 : longint;
           var _para6 : MPI_Aint; var _para7 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_get_contents';
function MPI_Type_create_subarray(_para1 : longint; var _para2 : longint; var _para3 : longint; var _para4 : longint; _para5 : longint;
           _para6 : MPI_Datatype; var _para7 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_create_subarray';
function MPI_Type_create_darray(_para1 : longint; _para2 : longint; _para3 : longint; var _para4 : longint; var _para5 : longint;
           var _para6 : longint; var _para7 : longint; _para8 : longint; _para9 : MPI_Datatype; var _para10 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'MPI_Type_create_darray';
function MPI_Info_create(var _para1 : MPI_Info) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_create';
function MPI_Info_set(_para1 : MPI_Info; _para2 : Pchar; _para3 : Pchar) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_set';
function MPI_Info_delete(_para1 : MPI_Info; _para2 : Pchar) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_delete';
function MPI_Info_get(_para1 : MPI_Info; _para2 : Pchar; _para3 : longint; _para4 : Pchar; var _para5 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_get';
function MPI_Info_get_valuelen(_para1 : MPI_Info; _para2 : Pchar; var _para3 : longint; var _para4 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_get_valuelen';
function MPI_Info_get_nkeys(_para1 : MPI_Info; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_get_nkeys';
function MPI_Info_get_nthkey(_para1 : MPI_Info; _para2 : longint; _para3 : Pchar) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_get_nthkey';
function MPI_Info_dup(_para1 : MPI_Info; var _para2 : MPI_Info) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_dup';
function MPI_Info_free(var info : MPI_Info) : longint;cdecl;external 'mpich.dll' name 'MPI_Info_free';
//function MPI_Info_c2f(_para1 : MPI_Info) : MPI_Fint;cdecl;external 'mpich.dll' name 'MPI_Info_c2f';
//function MPI_Info_f2c(_para1 : MPI_Fint) : MPI_Info;cdecl;external 'mpich.dll' name 'MPI_Info_f2c';
//function MPI_Request_c2f(_para1 : MPI_Request) : MPI_Fint;cdecl;external 'mpich.dll' name 'MPI_Request_c2f';
function MPI_Status_set_cancelled(var _para1 : MPI_Status; _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Status_set_cancelled';
function MPI_Status_set_elements(var _para1 : MPI_Status; _para2 : MPI_Datatype; _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'MPI_Status_set_elements';

function PMPI_Send(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Send';
function PMPI_Recv(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_Recv';
function PMPI_Get_count(var _para1 : MPI_Status; _para2 : MPI_Datatype; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Get_count';
function PMPI_Bsend(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Bsend';
function PMPI_Ssend(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Ssend';
function PMPI_Rsend(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Rsend';
function PMPI_Buffer_attach(buffer : pointer; _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Buffer_attach';
function PMPI_Buffer_detach(buffer : pointer; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Buffer_detach';
function PMPI_Isend(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_Isend';
function PMPI_Ibsend(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_Ibsend';
function PMPI_Issend(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_Issend';
function PMPI_Irsend(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_Irsend';
function PMPI_Irecv(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_Irecv';
function PMPI_Wait(var _para1 : MPI_Request; var _para2 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_Wait';
function PMPI_Test(var _para1 : MPI_Request; var flag : longint; var _para3 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_Test';
function PMPI_Request_free(var _para1 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_Request_free';
function PMPI_Waitany(_para1 : longint; var _para2 : MPI_Request; var _para3 : longint; var _para4 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_Waitany';
function PMPI_Testany(_para1 : longint; var _para2 : MPI_Request; var _para3 : longint; var _para4 : longint; var _para5 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_Testany';
function PMPI_Waitall(_para1 : longint; var _para2 : MPI_Request; var _para3 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_Waitall';
function PMPI_Testall(_para1 : longint; var _para2 : MPI_Request; var flag : longint; var _para4 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_Testall';
function PMPI_Waitsome(_para1 : longint; var _para2 : MPI_Request; var _para3 : longint; var _para4 : longint; var _para5 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_Waitsome';
function PMPI_Testsome(_para1 : longint; var _para2 : MPI_Request; var _para3 : longint; var _para4 : longint; var _para5 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_Testsome';
function PMPI_Iprobe(_para1 : longint; _para2 : longint; _para3 : MPI_Comm; var flag : longint; var _para5 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_Iprobe';
function PMPI_Probe(_para1 : longint; _para2 : longint; _para3 : MPI_Comm; var _para4 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_Probe';
function PMPI_Cancel(var _para1 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_Cancel';
function PMPI_Test_cancelled(var _para1 : MPI_Status; var flag : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Test_cancelled';
function PMPI_Send_init(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_Send_init';
function PMPI_Bsend_init(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_Bsend_init';
function PMPI_Ssend_init(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_Ssend_init';
function PMPI_Rsend_init(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_Rsend_init';
function PMPI_Recv_init(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : MPI_Comm; var _para7 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_Recv_init';
function PMPI_Start(var _para1 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_Start';
function PMPI_Startall(_para1 : longint; var _para2 : MPI_Request) : longint;cdecl;external 'mpich.dll' name 'PMPI_Startall';
function PMPI_Sendrecv(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : pointer; _para7 : longint; _para8 : MPI_Datatype; _para9 : longint; _para10 : longint;
           _para11 : MPI_Comm; var _para12 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_Sendrecv';
function PMPI_Sendrecv_replace(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : longint;
           _para6 : longint; _para7 : longint; _para8 : MPI_Comm; var _para9 : MPI_Status) : longint;cdecl;external 'mpich.dll' name 'PMPI_Sendrecv_replace';
function PMPI_Type_contiguous(_para1 : longint; _para2 : MPI_Datatype; var _para3 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_contiguous';
function PMPI_Type_vector(_para1 : longint; _para2 : longint; _para3 : longint; _para4 : MPI_Datatype; var _para5 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_vector';
function PMPI_Type_hvector(_para1 : longint; _para2 : longint; _para3 : MPI_Aint; _para4 : MPI_Datatype; var _para5 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_hvector';
function PMPI_Type_indexed(_para1 : longint; var _para2 : longint; var _para3 : longint; _para4 : MPI_Datatype; var _para5 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_indexed';
function PMPI_Type_hindexed(_para1 : longint; var _para2 : longint; var _para3 : MPI_Aint; _para4 : MPI_Datatype; var _para5 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_hindexed';
function PMPI_Type_struct(_para1 : longint; var _para2 : longint; var _para3 : MPI_Aint; var _para4 : MPI_Datatype; var _para5 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_struct';
function PMPI_Address(_para1 : pointer; var _para2 : MPI_Aint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Address';
function PMPI_Type_extent(_para1 : MPI_Datatype; var _para2 : MPI_Aint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_extent';
function PMPI_Type_size(_para1 : MPI_Datatype; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_size';
function PMPI_Type_lb(_para1 : MPI_Datatype; var _para2 : MPI_Aint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_lb';
function PMPI_Type_ub(_para1 : MPI_Datatype; var _para2 : MPI_Aint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_ub';
function PMPI_Type_commit(var _para1 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_commit';
function PMPI_Type_free(var _para1 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_free';
function PMPI_Get_elements(var _para1 : MPI_Status; _para2 : MPI_Datatype; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Get_elements';
function PMPI_Pack(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : pointer; _para5 : longint;
           var _para6 : longint; _para7 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Pack';
function PMPI_Unpack(_para1 : pointer; _para2 : longint; var _para3 : longint; _para4 : pointer; _para5 : longint;
           _para6 : MPI_Datatype; _para7 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Unpack';
function PMPI_Pack_size(_para1 : longint; _para2 : MPI_Datatype; _para3 : MPI_Comm; var _para4 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Pack_size';
function PMPI_Barrier(_para1 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Barrier';
function PMPI_Bcast(buffer : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : longint; _para5 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Bcast';
function PMPI_Gather(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : pointer; _para5 : longint;
           _para6 : MPI_Datatype; _para7 : longint; _para8 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Gather';
function PMPI_Gatherv(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : pointer; var _para5 : longint;
           var _para6 : longint; _para7 : MPI_Datatype; _para8 : longint; _para9 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Gatherv';
function PMPI_Scatter(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : pointer; _para5 : longint;
           _para6 : MPI_Datatype; _para7 : longint; _para8 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Scatter';
function PMPI_Scatterv(_para1 : pointer; var _para2 : longint; var displs : longint; _para4 : MPI_Datatype; _para5 : pointer;
           _para6 : longint; _para7 : MPI_Datatype; _para8 : longint; _para9 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Scatterv';
function PMPI_Allgather(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : pointer; _para5 : longint;
           _para6 : MPI_Datatype; _para7 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Allgather';
function PMPI_Allgatherv(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : pointer; var _para5 : longint;
           var _para6 : longint; _para7 : MPI_Datatype; _para8 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Allgatherv';
function PMPI_Alltoall(_para1 : pointer; _para2 : longint; _para3 : MPI_Datatype; _para4 : pointer; _para5 : longint;
           _para6 : MPI_Datatype; _para7 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Alltoall';
function PMPI_Alltoallv(_para1 : pointer; var _para2 : longint; var _para3 : longint; _para4 : MPI_Datatype; _para5 : pointer;
           var _para6 : longint; var _para7 : longint; _para8 : MPI_Datatype; _para9 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Alltoallv';
function PMPI_Reduce(_para1 : pointer; _para2 : pointer; _para3 : longint; _para4 : MPI_Datatype; _para5 : MPI_Op;
           _para6 : longint; _para7 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Reduce';
function PMPI_Op_create(var _para1 : MPI_User_function; _para2 : longint; var _para3 : MPI_Op) : longint;cdecl;external 'mpich.dll' name 'PMPI_Op_create';
function PMPI_Op_free(var _para1 : MPI_Op) : longint;cdecl;external 'mpich.dll' name 'PMPI_Op_free';
function PMPI_Allreduce(_para1 : pointer; _para2 : pointer; _para3 : longint; _para4 : MPI_Datatype; _para5 : MPI_Op;
           _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Allreduce';
function PMPI_Reduce_scatter(_para1 : pointer; _para2 : pointer; var _para3 : longint; _para4 : MPI_Datatype; _para5 : MPI_Op;
           _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Reduce_scatter';
function PMPI_Scan(_para1 : pointer; _para2 : pointer; _para3 : longint; _para4 : MPI_Datatype; _para5 : MPI_Op;
           _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Scan';
function PMPI_Group_size(group : MPI_Group; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Group_size';
function PMPI_Group_rank(group : MPI_Group; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Group_rank';
function PMPI_Group_translate_ranks(_para1 : MPI_Group; _para2 : longint; var _para3 : longint; _para4 : MPI_Group; var _para5 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Group_translate_ranks';
function PMPI_Group_compare(_para1 : MPI_Group; _para2 : MPI_Group; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Group_compare';
function PMPI_Comm_group(_para1 : MPI_Comm; var _para2 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'PMPI_Comm_group';
function PMPI_Group_union(_para1 : MPI_Group; _para2 : MPI_Group; var _para3 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'PMPI_Group_union';
function PMPI_Group_intersection(_para1 : MPI_Group; _para2 : MPI_Group; var _para3 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'PMPI_Group_intersection';
function PMPI_Group_difference(_para1 : MPI_Group; _para2 : MPI_Group; var _para3 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'PMPI_Group_difference';
function PMPI_Group_incl(group : MPI_Group; _para2 : longint; var _para3 : longint; var _para4 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'PMPI_Group_incl';
function PMPI_Group_excl(group : MPI_Group; _para2 : longint; var _para3 : longint; var _para4 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'PMPI_Group_excl';
function PMPI_Group_range_incl(group : MPI_Group; _para2 : longint; const _para3 : array of MPI_Triplet_range; var _para4 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'PMPI_Group_range_incl';
function PMPI_Group_range_excl(group : MPI_Group; _para2 : longint; const _para3 : array of MPI_Triplet_range; var _para4 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'PMPI_Group_range_excl';
function PMPI_Group_free(var _para1 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'PMPI_Group_free';
function PMPI_Comm_size(_para1 : MPI_Comm; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Comm_size';
function PMPI_Comm_rank(_para1 : MPI_Comm; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Comm_rank';
function PMPI_Comm_compare(_para1 : MPI_Comm; _para2 : MPI_Comm; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Comm_compare';
function PMPI_Comm_dup(_para1 : MPI_Comm; var _para2 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Comm_dup';
function PMPI_Comm_create(_para1 : MPI_Comm; _para2 : MPI_Group; var _para3 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Comm_create';
function PMPI_Comm_split(_para1 : MPI_Comm; _para2 : longint; _para3 : longint; var _para4 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Comm_split';
function PMPI_Comm_free(var _para1 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Comm_free';
function PMPI_Comm_test_inter(_para1 : MPI_Comm; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Comm_test_inter';
function PMPI_Comm_remote_size(_para1 : MPI_Comm; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Comm_remote_size';
function PMPI_Comm_remote_group(_para1 : MPI_Comm; var _para2 : MPI_Group) : longint;cdecl;external 'mpich.dll' name 'PMPI_Comm_remote_group';
function PMPI_Intercomm_create(_para1 : MPI_Comm; _para2 : longint; _para3 : MPI_Comm; _para4 : longint; _para5 : longint;
           var _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Intercomm_create';
function PMPI_Intercomm_merge(_para1 : MPI_Comm; _para2 : longint; var _para3 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Intercomm_merge';
function PMPI_Keyval_create(var _para1 : MPI_Copy_function; var _para2 : MPI_Delete_function; var _para3 : longint; _para4 : pointer) : longint;cdecl;external 'mpich.dll' name 'PMPI_Keyval_create';
function PMPI_Keyval_free(var _para1 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Keyval_free';
function PMPI_Attr_put(_para1 : MPI_Comm; _para2 : longint; _para3 : pointer) : longint;cdecl;external 'mpich.dll' name 'PMPI_Attr_put';
function PMPI_Attr_get(_para1 : MPI_Comm; _para2 : longint; _para3 : pointer; var _para4 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Attr_get';
function PMPI_Attr_delete(_para1 : MPI_Comm; _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Attr_delete';
function PMPI_Topo_test(_para1 : MPI_Comm; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Topo_test';
function PMPI_Cart_create(_para1 : MPI_Comm; _para2 : longint; var _para3 : longint; var _para4 : longint; _para5 : longint;
           var _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Cart_create';
function PMPI_Dims_create(_para1 : longint; _para2 : longint; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Dims_create';
function PMPI_Graph_create(_para1 : MPI_Comm; _para2 : longint; var _para3 : longint; var _para4 : longint; _para5 : longint;
           var _para6 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Graph_create';
function PMPI_Graphdims_get(_para1 : MPI_Comm; var _para2 : longint; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Graphdims_get';
function PMPI_Graph_get(_para1 : MPI_Comm; _para2 : longint; _para3 : longint; var _para4 : longint; var _para5 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Graph_get';
function PMPI_Cartdim_get(_para1 : MPI_Comm; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Cartdim_get';
function PMPI_Cart_get(_para1 : MPI_Comm; _para2 : longint; var _para3 : longint; var _para4 : longint; var _para5 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Cart_get';
function PMPI_Cart_rank(_para1 : MPI_Comm; var _para2 : longint; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Cart_rank';
function PMPI_Cart_coords(_para1 : MPI_Comm; _para2 : longint; _para3 : longint; var _para4 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Cart_coords';
function PMPI_Graph_neighbors_count(_para1 : MPI_Comm; _para2 : longint; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Graph_neighbors_count';
function PMPI_Graph_neighbors(_para1 : MPI_Comm; _para2 : longint; _para3 : longint; var _para4 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Graph_neighbors';
function PMPI_Cart_shift(_para1 : MPI_Comm; _para2 : longint; _para3 : longint; var _para4 : longint; var _para5 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Cart_shift';
function PMPI_Cart_sub(_para1 : MPI_Comm; var _para2 : longint; var _para3 : MPI_Comm) : longint;cdecl;external 'mpich.dll' name 'PMPI_Cart_sub';
function PMPI_Cart_map(_para1 : MPI_Comm; _para2 : longint; var _para3 : longint; var _para4 : longint; var _para5 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Cart_map';
function PMPI_Graph_map(_para1 : MPI_Comm; _para2 : longint; var _para3 : longint; var _para4 : longint; var _para5 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Graph_map';
function PMPI_Get_processor_name(_para1 : Pchar; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Get_processor_name';
function PMPI_Get_version(var _para1 : longint; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Get_version';
function PMPI_Errhandler_create(var _para1 : MPI_Handler_function; var _para2 : MPI_Errhandler) : longint;cdecl;external 'mpich.dll' name 'PMPI_Errhandler_create';
function PMPI_Errhandler_set(_para1 : MPI_Comm; _para2 : MPI_Errhandler) : longint;cdecl;external 'mpich.dll' name 'PMPI_Errhandler_set';
function PMPI_Errhandler_get(_para1 : MPI_Comm; var _para2 : MPI_Errhandler) : longint;cdecl;external 'mpich.dll' name 'PMPI_Errhandler_get';
function PMPI_Errhandler_free(var _para1 : MPI_Errhandler) : longint;cdecl;external 'mpich.dll' name 'PMPI_Errhandler_free';
function PMPI_Error_string(_para1 : longint; _para2 : Pchar; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Error_string';
function PMPI_Error_class(_para1 : longint; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Error_class';
function PMPI_Type_get_envelope(_para1 : MPI_Datatype; var _para2 : longint; var _para3 : longint; var _para4 : longint; var _para5 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_get_envelope';
function PMPI_Type_get_contents(_para1 : MPI_Datatype; _para2 : longint; _para3 : longint; _para4 : longint; var _para5 : longint;
           var _para6 : MPI_Aint; var _para7 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_get_contents';
function PMPI_Type_create_subarray(_para1 : longint; var _para2 : longint; var _para3 : longint; var _para4 : longint; _para5 : longint;
           _para6 : MPI_Datatype; var _para7 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_create_subarray';
function PMPI_Type_create_darray(_para1 : longint; _para2 : longint; _para3 : longint; var _para4 : longint; var _para5 : longint;
           var _para6 : longint; var _para7 : longint; _para8 : longint; _para9 : MPI_Datatype; var _para10 : MPI_Datatype) : longint;cdecl;external 'mpich.dll' name 'PMPI_Type_create_darray';
function PMPI_Info_create(var _para1 : MPI_Info) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_create';
function PMPI_Info_set(_para1 : MPI_Info; _para2 : Pchar; _para3 : Pchar) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_set';
function PMPI_Info_delete(_para1 : MPI_Info; _para2 : Pchar) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_delete';
function PMPI_Info_get(_para1 : MPI_Info; _para2 : Pchar; _para3 : longint; _para4 : Pchar; var _para5 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_get';
function PMPI_Info_get_valuelen(_para1 : MPI_Info; _para2 : Pchar; var _para3 : longint; var _para4 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_get_valuelen';
function PMPI_Info_get_nkeys(_para1 : MPI_Info; var _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_get_nkeys';
function PMPI_Info_get_nthkey(_para1 : MPI_Info; _para2 : longint; _para3 : Pchar) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_get_nthkey';
function PMPI_Info_dup(_para1 : MPI_Info; var _para2 : MPI_Info) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_dup';
function PMPI_Info_free(var _para1 : MPI_Info) : longint;cdecl;external 'mpich.dll' name 'PMPI_Info_free';
//function PMPI_Info_c2f(_para1 : MPI_Info) : MPI_Fint;cdecl;external 'mpich.dll' name 'PMPI_Info_c2f';
//function PMPI_Info_f2c(_para1 : MPI_Fint) : MPI_Info;cdecl;external 'mpich.dll' name 'PMPI_Info_f2c';

//function PMPI_Init(var _para1 : longint; _para2 : PPPchar) : longint;cdecl;external 'mpich.dll' name 'PMPI_Init';
function PMPI_Init(var _para1 : longint; var _para2 : Pchar) : longint;cdecl;external 'mpich.dll' name 'PMPI_Init';

//function PMPI_Init_thread(var _para1 : longint; _para2 : PPPchar; _para3 : longint; var _para4 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Init_thread';
function PMPI_Init_thread(var _para1 : longint; var _para2 : Pchar; _para3 : longint; var _para4 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Init_thread';
function PMPI_Finalize : longint;cdecl;external 'mpich.dll' name 'PMPI_Finalize';
function PMPI_Initialized(var _para1 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Initialized';
function PMPI_Abort(_para1 : MPI_Comm; _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Abort';
function PMPI_Comm_set_name(_para1 : MPI_Comm; _para2 : Pchar) : longint;cdecl;external 'mpich.dll' name 'PMPI_Comm_set_name';
function PMPI_Comm_get_name(_para1 : MPI_Comm; _para2 : Pchar; var _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Comm_get_name';

//function PMPI_Pcontrol(_para1 : longint; args : array of const) : longint;cdecl;external 'mpich.dll' name 'PMPI_Pcontrol';
function PMPI_Pcontrol(_para1 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Pcontrol';

function PMPI_Status_set_cancelled(var _para1 : MPI_Status; _para2 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Status_set_cancelled';
function PMPI_Status_set_elements(var _para1 : MPI_Status; _para2 : MPI_Datatype; _para3 : longint) : longint;cdecl;external 'mpich.dll' name 'PMPI_Status_set_elements';

{$endif}
{$endif}

implementation

function MPI_CHAR : MPI_Datatype;
  begin
     MPI_CHAR := MPI_Datatype(1);
  end;

function MPI_UNSIGNED_CHAR : MPI_Datatype;
  begin
     MPI_UNSIGNED_CHAR := MPI_Datatype(2);
  end;

function MPI_BYTE : MPI_Datatype;
  begin
     MPI_BYTE := MPI_Datatype(3);
  end;

function MPI_SHORT : MPI_Datatype;
  begin
     MPI_SHORT := MPI_Datatype(4);
  end;

function MPI_UNSIGNED_SHORT : MPI_Datatype;
  begin
     MPI_UNSIGNED_SHORT := MPI_Datatype(5);
  end;

function MPI_INT : MPI_Datatype;
  begin
     MPI_INT := MPI_Datatype(6);
  end;

function MPI_UNSIGNED : MPI_Datatype;
  begin
     MPI_UNSIGNED := MPI_Datatype(7);
  end;

function MPI_LONG : MPI_Datatype;
  begin
     MPI_LONG := MPI_Datatype(8);
  end;

function MPI_UNSIGNED_LONG : MPI_Datatype;
  begin
     MPI_UNSIGNED_LONG := MPI_Datatype(9);
  end;

function MPI_FLOAT : MPI_Datatype;
  begin
     MPI_FLOAT := MPI_Datatype(10);
  end;

function MPI_DOUBLE : MPI_Datatype;
  begin
     MPI_DOUBLE := MPI_Datatype(11);
  end;

function MPI_LONG_DOUBLE : MPI_Datatype;
  begin
     MPI_LONG_DOUBLE := MPI_Datatype(12);
  end;

function MPI_LONG_LONG_INT : MPI_Datatype;
  begin
     MPI_LONG_LONG_INT := MPI_Datatype(13);
  end;

function MPI_LONG_LONG : MPI_Datatype;
  begin
     MPI_LONG_LONG := MPI_Datatype(13);
  end;

function MPI_PACKED : MPI_Datatype;
  begin
     MPI_PACKED := MPI_Datatype(14);
  end;

function MPI_LB : MPI_Datatype;
  begin
     MPI_LB := MPI_Datatype(15);
  end;

function MPI_UB : MPI_Datatype;
  begin
     MPI_UB := MPI_Datatype(16);
  end;

function MPI_FLOAT_INT : MPI_Datatype;
  begin
     MPI_FLOAT_INT := MPI_Datatype(17);
  end;

function MPI_DOUBLE_INT : MPI_Datatype;
  begin
     MPI_DOUBLE_INT := MPI_Datatype(18);
  end;

function MPI_LONG_INT : MPI_Datatype;
  begin
     MPI_LONG_INT := MPI_Datatype(19);
  end;

function MPI_SHORT_INT : MPI_Datatype;
  begin
     MPI_SHORT_INT := MPI_Datatype(20);
  end;

function MPI_2INT : MPI_Datatype;
  begin
     MPI_2INT := MPI_Datatype(21);
  end;

function MPI_LONG_DOUBLE_INT : MPI_Datatype;
  begin
     MPI_LONG_DOUBLE_INT := MPI_Datatype(22);
  end;

function MPI_COMPLEX : MPI_Datatype;
  begin
     MPI_COMPLEX := MPI_Datatype(23);
  end;

function MPI_DOUBLE_COMPLEX : MPI_Datatype;
  begin
     MPI_DOUBLE_COMPLEX := MPI_Datatype(24);
  end;

function MPI_LOGICAL : MPI_Datatype;
  begin
     MPI_LOGICAL := MPI_Datatype(25);
  end;

function MPI_REAL : MPI_Datatype;
  begin
     MPI_REAL := MPI_Datatype(26);
  end;

function MPI_DOUBLE_PRECISION : MPI_Datatype;
  begin
     MPI_DOUBLE_PRECISION := MPI_Datatype(27);
  end;

function MPI_INTEGER : MPI_Datatype;
  begin
     MPI_INTEGER := MPI_Datatype(28);
  end;

function MPI_2INTEGER : MPI_Datatype;
  begin
     MPI_2INTEGER := MPI_Datatype(29);
  end;

function MPI_2COMPLEX : MPI_Datatype;
  begin
     MPI_2COMPLEX := MPI_Datatype(30);
  end;

function MPI_2DOUBLE_COMPLEX : MPI_Datatype;
  begin
     MPI_2DOUBLE_COMPLEX := MPI_Datatype(31);
  end;

function MPI_2REAL : MPI_Datatype;
  begin
     MPI_2REAL := MPI_Datatype(32);
  end;

function MPI_2DOUBLE_PRECISION : MPI_Datatype;
  begin
     MPI_2DOUBLE_PRECISION := MPI_Datatype(33);
  end;

function MPI_CHARACTER : MPI_Datatype;
  begin
     MPI_CHARACTER := MPI_Datatype(1);
  end;

function MPI_MAX : MPI_Op;
  begin
     MPI_MAX := MPI_Op(100);
  end;

function MPI_MIN : MPI_Op;
  begin
     MPI_MIN := MPI_Op(101);
  end;

function MPI_SUM : MPI_Op;
  begin
     MPI_SUM := MPI_Op(102);
  end;

function MPI_PROD : MPI_Op;
  begin
     MPI_PROD := MPI_Op(103);
  end;

function MPI_LAND : MPI_Op;
  begin
     MPI_LAND := MPI_Op(104);
  end;

function MPI_BAND : MPI_Op;
  begin
     MPI_BAND := MPI_Op(105);
  end;

function MPI_LOR : MPI_Op;
  begin
     MPI_LOR := MPI_Op(106);
  end;

function MPI_BOR : MPI_Op;
  begin
     MPI_BOR := MPI_Op(107);
  end;

function MPI_LXOR : MPI_Op;
  begin
     MPI_LXOR := MPI_Op(108);
  end;

function MPI_BXOR : MPI_Op;
  begin
     MPI_BXOR := MPI_Op(109);
  end;

function MPI_MINLOC : MPI_Op;
  begin
     MPI_MINLOC := MPI_Op(110);
  end;

function MPI_MAXLOC : MPI_Op;
  begin
     MPI_MAXLOC := MPI_Op(111);
  end;

function MPI_COMM_NULL : MPI_Comm;
  begin
     MPI_COMM_NULL := MPI_Comm(0);
  end;

function MPI_OP_NULL : MPI_Op;
  begin
     MPI_OP_NULL := MPI_Op(0);
  end;

function MPI_GROUP_NULL : MPI_Group;
  begin
     MPI_GROUP_NULL := MPI_Group(0);
  end;

function MPI_DATATYPE_NULL : MPI_Datatype;
  begin
     MPI_DATATYPE_NULL := MPI_Datatype(0);
  end;

function MPI_REQUEST_NULL : MPI_Request;
  begin
     MPI_REQUEST_NULL := MPI_Request(0);
  end;

function MPI_ERRHANDLER_NULL : MPI_Errhandler;
  begin
     MPI_ERRHANDLER_NULL := MPI_Errhandler(0);
  end;

function MPI_BOTTOM : pointer;
  begin
     MPI_BOTTOM := pointer(0);
  end;

function MPI_ERRORS_ARE_FATAL : MPI_Errhandler;
  begin
     MPI_ERRORS_ARE_FATAL := MPI_Errhandler(119);
  end;

function MPI_ERRORS_RETURN : MPI_Errhandler;
  begin
     MPI_ERRORS_RETURN := MPI_Errhandler(120);
  end;

function MPIR_ERRORS_WARN : MPI_Errhandler;
  begin
     MPIR_ERRORS_WARN := MPI_Errhandler(121);
  end;

function MPI_INFO_NULL : MPI_Info;
  begin
     MPI_INFO_NULL := MPI_Info(0);
  end;

//

function ANSI_ARGS(a : longint) : longint;
begin
   ANSI_ARGS:=a;
end;

//

function MPI_FILE_NULL : MPI_File;
  begin
     MPI_FILE_NULL:=MPI_File(0);
  end;

function MPIO_REQUEST_NULL : MPIO_Request;
  begin
     MPIO_REQUEST_NULL:=MPIO_Request(0);
  end;

//


function MPI_Comm_c2f(comm : longint) : MPI_Fint;
begin
   MPI_Comm_c2f := MPI_Fint(comm);
end;

function MPI_Comm_f2c(comm : longint) : MPI_Comm;
begin
   MPI_Comm_f2c := MPI_Comm(comm);
end;

function MPI_Type_c2f(datatype : longint) : MPI_Fint;
begin
   MPI_Type_c2f := MPI_Fint(datatype);
end;

function MPI_Type_f2c(datatype : longint) : MPI_Datatype;
begin
   MPI_Type_f2c := MPI_Datatype(datatype);
end;

function MPI_Group_c2f(group : longint) : MPI_Fint;
begin
   MPI_Group_c2f := MPI_Fint(group);
end;

function MPI_Group_f2c(group : longint) : MPI_Group;
begin
   MPI_Group_f2c := MPI_Group(group);
end;

function MPI_Request_f2c(request : longint) : MPI_Request;
begin
// can't implement :((
//   MPI_Request_f2c := MPI_Request(MPIR_ToPointer(request));
end;

function MPI_Op_c2f(op : longint) : MPI_Fint;
begin
   MPI_Op_c2f := MPI_Fint(op);
end;

function MPI_Op_f2c(op : longint) : MPI_Op;
begin
   MPI_Op_f2c := MPI_Op(op);
end;

function MPI_Errhandler_c2f(errhandler : longint) : MPI_Fint;
begin
   MPI_Errhandler_c2f := MPI_Fint(errhandler);
end;

function MPI_Errhandler_f2c(errhandler : longint) : MPI_Errhandler;
begin
   MPI_Errhandler_f2c := MPI_Errhandler(errhandler);
end;

function MPI_Win_c2f(win : longint) : MPI_Fint;
begin
   MPI_Win_c2f := MPI_Fint(win);
end;
{
function MPI_Win_f2c(win : longint) : MPI_Win;
begin
   MPI_Win_f2c := MPI_Win(win);
end;
}
{
function MPI_STATUS_IGNORE : ^MPI_Status;
  begin
     MPI_STATUS_IGNORE := ^MPI_Status(0);
  end;

function MPI_STATUSES_IGNORE : ^MPI_Status;
  begin
     MPI_STATUSES_IGNORE := ^MPI_Status(0);
  end;
}


end.


