unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Buttons, XMLRead, DOM, ComCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    OpenDialog1: TOpenDialog;
    XMLFile: TEdit;
    element2find: TEdit;
    attribut2find: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    output: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);

  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

{ TForm1 }


procedure addToOutput(N:TDOMNode);
var s:string;
    E:TDOMElement;
    i:integer;
begin
 s:= 'Name: ' + N.NodeName;

 if N.NodeName = form1.element2find.text then
  begin
   s := s + ' Found element!';
  end;

 if N.NodeName <> '#text' then
  begin
   E := N as TDOMElement;
   i := E.attributes.Length;
   s := s + ' Count Attribute ' + inttostr(i);
   if E[form1.attribut2find.text]<>'' then
    s := s + ' Found Attribut';
  end; {nodename <> text}
  
 form1.output.lines.add(s);
end;


procedure ParseXML(knoten:TDomNode);
var 
  E:TDOMElement;
  N, sub:TDomNode;
  i, zaehler:integer;
begin
 E:=knoten as TDomElement;
 N:=E.FirstChild;

 While (N<>Nil) do
  begin
    addToOutput(N);
    if N.HasChildNodes then
    begin
      I:= N.childnodes.Count;
      sub := N.FirstChild;
      addToOutput(sub);

      if sub.haschildnodes then
        ParseXML(sub);
          
      for zaehler := 1 to i-1 do
       begin
        sub := sub.NextSibling;
        addToOutput(sub);

        if sub.HasChildNodes then
          ParseXML(sub);
      end; {for zaehler}
      
    end;

    N:=N.NextSibling;
 end; {while}
end;


procedure TForm1.Button1Click(Sender: TObject);

begin
  if opendialog1.execute then
    XMLFile.text := opendialog1.filename;
end;

procedure TForm1.Button2Click(Sender: TObject);
var 
  doc:txmldocument;
  temp:TDomNode;
begin
  output.lines.clear;
  ReadXMLFile(doc, XMLFile.text);
  temp := doc.DocumentElement;
  ParseXML(temp);
end;

initialization
  {$I unit1.lrs}

end.

