{ Пример подключения функций из внешних библиотек. 
  Фортран.
  Вычисление СЛАУ. }
{$mode objfpc}
Uses SysUtils;

Const
//  count = 5;	// Для проверки правильности работы функции
  count = 2000;
  LAPACK = 'libopenblas.dll';
//  LAPACK = 'liblapack.dll';
//  LAPACK = 'liblapack.so';


Type
  TVector = array of double;
  TMatrix = array of TVector;

// Генератор исходной матрицы коэффициентов и правой части уравнений
procedure GenMatrix(var A: TMatrix; var B: TVector; row, col: DWord; rnd: boolean = False);
Var
  i, j: DWord;

Begin
  SetLength(A, row, col);
  SetLength(B, row);
  If rnd Then
    for i := 0 to row-1 do
    Begin
      for j := 0 to col-1 do
        A[i,j]:=Random();
      B[i]:=Random();
    End;
End;

// Тестовые данные для проверки правильности работы dgesv
procedure TestData(var A: TMatrix; var B: TVector);
Begin
// тестовые данные A.
// Запоняется по фортраньему принципу - одна колонка - одно уравнение,
// вторая колонка - второе уравнениеи т.д.
  A[0,0]:=6.80;  A[0,1]:=-2.11; A[0,2]:=5.66;  A[0,3]:=5.97;  A[0,4]:=8.23;
  A[1,0]:=-6.05; A[1,1]:=-3.30; A[1,2]:=5.36;  A[1,3]:=-4.44; A[1,4]:=1.08;
  A[2,0]:=-0.45; A[2,1]:=2.58;  A[2,2]:=-2.70; A[2,3]:=0.27;  A[2,4]:=9.04;
  A[3,0]:=8.32;  A[3,1]:=2.71;  A[3,2]:=4.35;  A[3,3]:=-7.17; A[3,4]:=2.14;
  A[4,0]:=-9.67; A[4,1]:=-5.14; A[4,2]:=-7.26; A[4,3]:=6.08;  A[4,4]:=-6.87;

// Тестовые данные B
  B[0]:=4.02; B[1]:=6.19; B[2]:=-8.22; B[3]:=-7.57; B[4]:=-3.03;

// С ними должно получиться в X
{ -0.80 
  -0.70
   0.59
   1.32
   0.57
}
End;

// Транспонирование квадратной матрицы.
// Параметры:
//	n - размеры одного бока матрицы
procedure MatrixTrans(var X: TMatrix; n: DWord);
Var
  i,j:integer;
  k: double;
Begin
 for i:=0 to n-1 do
  for j:=1 to n-1 do
    begin
     k:=X[i,j];
     X[i,j]:=X[j,i];
     X[j,i]:=k;
    end;
End;

// Прелюоазование матрицы из двумерной в одномерный массив
function Matrix2Array(A: TMatrix; cnt: DWord): TVector;
Var
  i, j, k: DWord;
Begin
  SetLength(Result, cnt*cnt);
  k:=0;
  For i:=0 To cnt-1 Do
    For j:=0 To cnt-1 Do
    Begin
      Result[k]:=A[i,j];
      Inc(k);
    End;
End;

{ Библиотека Lapack. Решение СЛАУ для матрицы типа Double методом LU-разложения.
  a * X = b
  
  Все параметры функции - указатели.
  Параметры:
	n - количество уравнений;
	nrhs - количество колонок правой части, обычно 1;
	a - матрица коэффициентов [n, n], после решения - результат LU-разложения;
	lda - количество столбцов a, обычно сюда вставляют n;
	ipiv - массив перестановок, целочисленный [n];
	b - массив правых частей уравнения [n], а после решения - переменные X.
		Может быть многостолбцовым, если есть несколько вариантов
		правых частей;
	ldb - кол-во строк b. Обычно n;
	info - результат выполнения функции:
		0 - всё прошло прекрасно;
		< 0 - аргумент с этим номером имеет недопустимое значение;
		> 0 - A[info,info] равен нулю.
}
function dgesv(n, nrhs: PInteger; 
		a: PDouble; 
		lda, ipiv: PInteger; 
		b: PDouble;
		ldb, info: PInteger): integer; cdecl; external LAPACK name 'dgesv_';


// Наша функция для решения СЛАУ
// Параметры:
//	a - матрица коэффициентов;
//	b - вектор правых частей уравнений. После решения здесь вектор X решений;
//	n - количество уравнений.
// Возвращаемое значение:
//	Аналогично параметру info функции dgesv.
function SolveLapackSLE(var a: TMatrix; var b: TVector; n: DWord): integer;
Var
  nrhs: integer;
  ipiv: array of integer;
  TempA: array of double;
Begin
  SetLength(ipiv, n);
  nrhs:=1;
  TempA:=Matrix2Array(a, n);
  dgesv(@n, @nrhs, @TempA[0], @n, @ipiv[0], @b[0], @n, @Result);
End;

// Вывод матрицы на экран
procedure PrintMatrix(A: TMatrix; cnt: DWord);
Var
  i, j: integer;
Begin
  for i := 0 to Cnt-1 do
  Begin
    for j := 0 to Cnt-1 do
      Write(A[i, j]:5:2, ' ');
    WriteLn;
  End;
End;

// Вывод транспонированной матрицы без транспонирования
procedure PrintMatrix2(A: TMatrix; cnt: DWord);
Var
  i, j: integer;
Begin
  for i := 0 to Cnt-1 do
  Begin
    for j := 0 to Cnt-1 do
      Write(A[j, i]:5:2, ' ');
    WriteLn;
  End;
End;

// Вывод вектора на экран
procedure PrintVector(A: TVector; cnt: DWord);
Var
  i: integer;
Begin
  for i := 0 to Cnt-1 do
    WriteLn(A[i]:5:2, ' ');
End;

// Проверка расхождения решения
procedure CheckSolve(A: TMatrix; B, X: TVector; cnt: DWord);
Var
  i, j: DWord;
  r: array of double;
begin
  SetLength(r, cnt);
  For i:=0 To cnt-1 Do
  Begin  
    For j:=0 To cnt-1 Do
      r[i]:=r[i]+A[i,j]*X[i];
    r[i]:=B[i]-r[i];
  End;
  PrintVector(r, cnt);
End;


Var
  a: TMatrix;
  b: TVector;
  res: integer;

Begin
  Randomize;
  GenMatrix(a, b, Count, Count, True);

//  TestData(a, b);

{  Writeln('Matrix a: ');
  PrintMatrix(a, Count);
  Writeln('Matrix a 2');
  PrintMatrix2(a, Count);
  WriteLn('Vector b: ');
  PrintVector(b, Count);
  WriteLn;
}
  WriteLn(FormatDateTime('hh:nn:ss:zz', Now));
  res:=SolveLapackSLE(a, b, Count);
  If res<>0 Then
    WriteLn('Что-то пощло не так...')
  Else
    WriteLn('Всё путём!');

  WriteLn(FormatDateTime('hh:nn:ss:zz', Now));
//  WriteLn('Решение:');
//  PrintVector(b, Count);
//  WriteLn('Расхождение:');
//  CheckSolve(a, b, x);
End.
