program test_alglib;
{*********************************************
 * Тестирование скорости работы библиотеки
 * alglib. Решение СЛАУ.
 * 
 *********************************************}
{$mode objfpc}
Uses sysutils, DateUtils, xalglib;

Const
  n = 2000;

Var
  a: TMatrix;
  b: TVector;
  info: TALGLIBInteger;
  rep: Tdensesolverreport;
  x: TVector;
  i, j: integer;
  t1, t2: TTime;

begin
  Randomize;
  SetLength(a, n, n);
  SetLength(b, n);
  SetLength(x, n);
  WriteLn('Заполнение матрицы A...');
  For i:=0 To n-1 Do
  Begin  
    For j:=0 To n-1 Do
      a[i,j]:=Random;
  End;
  WriteLn('Готово!');

  // Генерация значений B
  WriteLn('Запонение вектора b...');
  for i:= 0 to n-1 do
    b[i]:=random+1;
  WriteLn('Готово!');
  
  WriteLn('Вычисление...');
  t1:=Time;
  rmatrixsolve(a, n, b, info, rep, x);
  t2:=Time;
  WriteLn('Готово!');

  If Info=1 Then
  begin
    WriteLn('Время вычисления:');
    WriteLn(Millisecondsbetween(t2, t1)/1000:10:3, ' sec.')
  End
  Else
    WriteLn(Info);
end.