unit frm_main;

{$mode objfpc}{$H+}

interface

uses
  SysUtils, Classes, fpg_base, fpg_main, fpg_form,
  fpg_grid, fpg_button, fpg_panel;

type

  TSystemInfo = class(TfpgForm)
  private
    {@VFD_HEAD_BEGIN: SystemInfo}
    Grid1: TfpgStringGrid;
    Button1: TfpgButton;
    Panel1: TfpgPanel;
    {@VFD_HEAD_END: SystemInfo}

    procedure Button1Click(Sender: TObject);
    procedure GetInfo;
    
  public
    procedure AfterCreate; override;
  end;

{@VFD_NEWFORM_DECL}

implementation

{@VFD_NEWFORM_IMPL}

procedure TSystemInfo.AfterCreate;
begin
  {%region 'Auto-generated GUI code' -fold}
  {@VFD_BODY_BEGIN: SystemInfo}
  Name := 'SystemInfo';
  SetPosition(300, 150, 589, 394);
  WindowTitle := 'SystemInfo';
  Hint := '';

  Grid1 := TfpgStringGrid.Create(self);
  with Grid1 do
  begin
    Name := 'Grid1';
    SetPosition(20, 16, 552, 220);
    BackgroundColor := TfpgColor($80000002);
    AddColumn('Название', 200, taLeftJustify);
    AddColumn('Значение', 330, taLeftJustify);
    FontDesc := '#Grid';
    HeaderFontDesc := '#GridHeader';
    Hint := '';
    RowCount := 12;
    RowSelect := False;
    TabOrder := 1;
  end;

  Button1 := TfpgButton.Create(self);
  with Button1 do
  begin
    Name := 'Button1';
    SetPosition(492, 356, 80, 24);
    Text := 'Выход';
    FontDesc := '#Label1';
    Hint := '';
    ImageName := '';
    TabOrder := 3;
    OnClick:=@Button1Click
  end;

  Panel1 := TfpgPanel.Create(self);
  with Panel1 do
  begin
    Name := 'Panel1';
    SetPosition(20, 244, 552, 100);
    FontDesc := '#Label1';
    Hint := '';
    Text := 'Panel';
    WrapText := True;
    Text := 'Операционная система:'+#$A;
  end;

  {@VFD_BODY_END: SystemInfo}
  {%endregion}
  GetInfo;
end;

//Сбор информации о системе
procedure TSystemInfo.GetInfo;
Var
  FFile: TStringList;
  i, j: integer;
begin
  FFile:=TStringList.Create;
  FFile.NameValueSeparator:=':';
  FFile.Duplicates:=dupIgnore;
  
  //Информация о процессоре
  FFile.LoadFromFile('/proc/cpuinfo');
  Grid1.Columns[0].Cells[0]:='--Информация о процессоре';
  
  For i:=0 To FFile.Count-1 Do
  Begin
  j:=Pos(':', FFile[i])+2;
  If Pos('model name', FFile[i])>0 Then
  Begin
    Grid1.Columns[0].Cells[1]:='Модель';
    Grid1.Columns[1].Cells[1]:=Copy(FFile[i], j, Length(FFile[i])-j+2);
  End;
  If Pos('cpu MHz', FFile[i])>0 Then
  Begin
    Grid1.Columns[0].Cells[2]:='Частота';
    Grid1.Columns[1].Cells[2]:=Copy(FFile[i], j, Length(FFile[i])-j+2);
  End;
  If Pos('cache size', FFile[i])>0 Then
  Begin
    Grid1.Columns[0].Cells[3]:='Кэш';
    Grid1.Columns[1].Cells[3]:=Copy(FFile[i], j, Length(FFile[i])-j+2);
  End;
  If Pos('cpu cores', FFile[i])>0 Then
  Begin
    Grid1.Columns[0].Cells[4]:='Кол-во ядер';
    Grid1.Columns[1].Cells[4]:=Copy(FFile[i], j, Length(FFile[i])-j+2);  
  End;
  If Pos('bogomips', FFile[i])>0 then
  Begin
    Grid1.Columns[0].Cells[5]:='Производительность';
    Grid1.Columns[1].Cells[5]:=Copy(FFile[i], j, Length(FFile[i])-j+2); 
  End;
  
  End;

  //Информация о памяти
  FFile.LoadFromFile('/proc/meminfo');
  Grid1.Columns[0].Cells[6]:='--Информация о памяти';

  Grid1.Columns[0].Cells[7]:='ОЗУ всего';
  Grid1.Columns[1].Cells[7]:=FFile.Values['MemTotal'];
  Grid1.Columns[0].Cells[8]:='ОЗУ свободно';
  Grid1.Columns[1].Cells[8]:=FFile.Values['MemFree'];
  Grid1.Columns[0].Cells[9]:='Своп-память всего';
  Grid1.Columns[1].Cells[9]:=FFile.Values['SwapTotal'];
  Grid1.Columns[0].Cells[10]:='Своп-память свободно';
  Grid1.Columns[1].Cells[10]:=FFile.Values['SwapFree'];  

  //Название операционной системы
  FFile.LoadFromFile('/etc/issue');
  Panel1.Text:=Panel1.Text+FFile[0]+#$A;
  
  //Версия ядра
  FFile.LoadFromFile('/proc/version');
  Panel1.Text:=Panel1.Text+FFile[0];
  
  FFile.Free;
end;

//Событие нажатия на кнопку
procedure TSystemInfo.Button1Click(Sender: TObject);
begin
  Close;
end;

end.
