{$APPTYPE GUI}
{$mode objfpc}
Uses Windows, sqlite3, minisysutil, myview_ctrls;

{$R myview.rc}

Const
  MYTIMER = 100;
  DBFILE = 'traffic.db3';

Type
  TTarif = record
    name: AnsiString;
    value: AnsiString;
  end;

  TTraffic = record
    bytes: AnsiString;
    value: AnsiString;
  end;

Var
  db : PPsqlite3;
  CurRecord: DWord;
  Tarif: TTarif;
  Traffic: TTraffic;
  MainWnd: HWND;

//    
procedure InitCommonControls; external 'comctl32' name 'InitCommonControls';

//    
Function GetStartData(_param1: pointer; ArgCount: longint; PVal: PPchar; PName: PPchar): longint; cdecl;
Begin
  Tarif.name:=PVal[0];
  Tarif.value:=PVal[1];
  
  Result:=0;
End;

//    
Function GetTimerData(_param1: pointer; ArgCount: longint; PVal: PPchar; PName: PPchar): longint; cdecl;
begin
  traffic.bytes:=PVal[0];
  traffic.value:=PVal[1];

  Result:=0;
end;

//   
Procedure OnCreate(wnd:HWND);
Var
  rc: Integer;
  sql: AnsiString;
  pzErrMsg : PChar;

Begin
  CurRecord:=1;
  
  //  
  rc := SQLite3_Open(PChar(DBFILE), @db);
  If rc<>SQLITE_OK Then
  Begin
    MessageBox(0, PChar('     : '+DBFILE), '', MB_OK+MB_ICONSTOP);
    PostQuitMessage(0);
  End
  Else
  Begin  
    // 
    SetTimer(Wnd, MYTIMER, 3000, NIL);
    //   
    sql:='SELECT tarif, money FROM price';
    rc:=SQLite3_Exec(db, PChar(sql), @GetStartData, NIL, @pzErrMsg);
    If  rc<>SQLITE_OK  Then 
      MessageBox(0, pzErrMsg, ' ', MB_OK+MB_ICONSTOP)
    Else
    Begin
      SetWindowText(Wnd, PChar(' "'+tarif.name+'"'));
//      SendDlgItemMessage(Wnd, IDC_SBR1, SB_SETTEXT, 0, LPARAM(PChar(' : '+tarif.value+' .')))
    End;
  End;
End;

Procedure OnClose(wnd: HWND);
Begin
  KillTimer(wnd, MYTIMER);
  SQLite3_Close(db);
  DestroyWindow(wnd);
End;

//   
Procedure OnTimer(wnd: HWND);
Var
  rc: Integer;
  sql: AnsiString;
  pzErrMsg : PChar;

Begin
   //   
   sql := 'SELECT bytes, bytes*'+Tarif.value+' FROM traf WHERE computer="localhost" and id='+IntToStr(CurRecord)+';';
   rc:=SQLite3_Exec(db, PChar(sql), @GetTimerData, nil, @pzErrMsg);
   
   If  rc<>SQLITE_OK  Then 
     MessageBox(0, pzErrMsg, ' ', MB_OK+MB_ICONSTOP)
   Else
   Begin
     //     
     SendDlgItemMessage(wnd, IDC_EDT1, WM_SETTEXT, 0, LPARAM(PChar(Traffic.bytes)));
     SendDlgItemMessage(wnd, IDC_EDT2, WM_SETTEXT, 0, LPARAM(PChar(Traffic.value)));
   End;

   MessageBeep(MB_OK);
   If CurRecord<10 Then 
     Inc(CurRecord)
   Else
     CurRecord:=1;
End;

function WindowProc(wnd: HWND; Msg : Integer; wParam: Wparam; lParam: Lparam): Lresult; stdcall;
begin
  case msg of
    WM_CREATE: OnCreate(wnd);
    WM_TIMER : OnTimer(wnd);
    WM_COMMAND: If LoWord(wParam)=IDC_BTN2 Then OnClose(wnd);
    WM_CLOSE: OnClose(wnd);
    WM_DESTROY: PostQuitMessage(0);   
  else
    Result := DefWindowProc(wnd, msg, wparam, lparam);
  end;
end;

//    
Procedure RegWinClass;
Var
  wc: WNDCLASS;
  err: dword;

Begin
  wc.style:=cs_hredraw or cs_vredraw;
  wc.lpfnWndProc:=WndProc(@WindowProc);
  wc.cbClsExtra:=0;
  wc.cbWndExtra:=DLGWINDOWEXTRA;
  wc.hInstance:=GetModuleHandle(nil);;
  wc.hIcon:=LoadIcon(wc.hInstance, PChar(IDI_APPICON));
  wc.hCursor:=LoadCursor(0, IDC_ARROW);
  wc.hbrBackground:=COLOR_BTNFACE+1;
  wc.lpszMenuName:=nil;
  wc.lpszClassName:='WndClass1';
  
  If RegisterClass(@wc)=0 Then
  Begin
    err:=GetLastError;
    MessageBox(0, PChar(SysErrorMessage(err)), '', MB_OK);
  End;
End;

var
  Mesg: MSG;
  err: integer;

Begin
  //   
  RegWinClass;

  //    
  InitCommonControls;

  //   
  MainWnd:=CreateDialog(hInstance, PChar(IDD_DLG1), 0, NIL);
  If MainWnd=0 Then
  Begin
    err:=GetLastError;
    MessageBox(0, PChar(SysErrorMessage(err)), '', MB_OK);
  End;
  SendDlgItemMessage(MainWnd, IDC_SBR1, SB_SETTEXT, 0, LPARAM(PChar(' : '+tarif.value+' ./')));
  
  //   
  while GetMessage(Mesg, 0, 0, 0) do
  begin
    if mainWnd<>0 then
      if IsDialogMessage(mainWnd,Mesg) then
        continue;
      TranslateMessage(Mesg);
      DispatchMessage(Mesg);
  end;
End.