Unit minisysutil;

interface

function SysErrorMessage(ErrorCode: Integer): String;
function IntToStr(Value: integer): string;
function StrToInt(const S: string): integer;

implementation

Uses Windows;

function SysErrorMessage(ErrorCode: Integer): String;
var
  MsgBuffer: pChar;
begin
  MsgBuffer:=NIL;
  FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER or FORMAT_MESSAGE_FROM_SYSTEM,
                nil, ErrorCode, MakeLangId(LANG_NEUTRAL, SUBLANG_DEFAULT),
                MsgBuffer, 0, NIL);
  SysErrorMessage := StrPas(MsgBuffer);
  Dispose(MsgBuffer);
end;

function IntToStr(Value: integer): string;
begin
 System.Str(Value, result);
end ;

function StrToInt(const S: string): integer;
var Error: word;
begin
  Val(S, result, Error);
  If Error<>0 Then
    MessageBox(0, PChar('  :'+#13#10+s+#13#10+' '), 
               '', MB_OK+MB_ICONERROR);
end ;

end.