unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  ExtCtrls, Buttons, ComCtrls, sqlite3conn, sqldb;

type

  TDirQuery = (dqPrev, dqCurr, dqNext);

  { TForm1 }

  TForm1 = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    ListView1: TListView;
    Panel1: TPanel;
    SQLite3Connection1: TSQLite3Connection;
    SQLQuery1: TSQLQuery;
    SQLTransaction1: TSQLTransaction;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { private declarations }
    procedure GetCurrentPage(Dir: TDirQuery);
    FAllRecords: Integer;
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

{ TForm1 }

Const
  cPageSize = 100;

procedure TForm1.FormCreate(Sender: TObject);
begin
  //Определяем общее количество записей
  SQLQuery1.SQL.Clear;
  SQLQuery1.SQL.Text:='SELECT COUNT(*) FROM rus';
  SQLQuery1.Open;
  FAllRecords:=SQLQuery1.Fields[0].AsInteger;
  SQLQuery1.Close;

  //Основной запрос
  SQLQuery1.SQL.Clear;
  SQLQuery1.SQL.Add('SELECT rus.id, sol.name, rus.name');
  SQLQuery1.SQL.Add('FROM rus INNER JOIN sol');
  SQLQuery1.SQL.Add('ON rus.sol_id=sol.id');
  SQLQuery1.SQL.Add('ORDER BY sol.name, rus.name');
  SQLQuery1.SQL.Add('LIMIT '+IntToStr(cPageSize)+' OFFSET :n');
  SQLQuery1.Params[0].AsInteger:=0;
  SQLQuery1.Open;
  GetCurrentPage(dqCurr);
end;

//Кнопка получения следующей порци данных
procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  GetCurrentPage(dqNext);
end;

//Кнопка получения предыдущей порции данных
procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  GetCurrentPage(dqPrev);
end;

//Получение порции данных и заполнение ими компонента отображения
procedure TForm1.GetCurrentPage(Dir: TDirQuery);
Var
  i: Integer;
Begin
  //В зависимости от параметра процедуры определяем с какого номера записи проводить выборку
  Case Dir of
    dqPrev: If SQLQuery1.Params[0].AsInteger>=cPageSize Then
              SQLQuery1.Params[0].AsInteger:=SQLQuery1.Params[0].AsInteger-cPageSize;
    dqNext: If SQLQuery1.Params[0].AsInteger<=FAllRecords-cPageSize Then
              SQLQuery1.Params[0].AsInteger:=SQLQuery1.Params[0].AsInteger+cPageSize;
  End;

  SQLQuery1.Close;
  SQLQuery1.Open;
  ListView1.Items.Clear;

  //Заполняем полученой порцией данных компонент отображения
  For i:=0 To SQLQuery1.RecordCount-1 Do
  Begin
    ListView1.Items.Add;
    ListView1.Items[i].Caption:=SQLQuery1.Fields[0].AsString;
    ListView1.Items[i].SubItems.Add(SQLQuery1.Fields[1].AsString);
    ListView1.Items[i].SubItems.Add(SQLQuery1.Fields[2].AsString);
    SQLQuery1.Next;
  End;
End;

initialization
  {$I unit1.lrs}

end.

