{$MODE OBJFPC}

unit ComWindow;

interface

uses
  Windows,
  Commands;

const
  CN_MAIN = 'our_main_window';

implementation

procedure ProcessContextMenu (Wnd : HWnd; xPos, yPos : word);
 var
   Menu : HMenu;
   Dummy : PRect;
 begin
 Dummy := nil;
 Menu := CreatePopupMenu ();
 AppendMenu (Menu, MF_STRING, CMD_FIRST, ' ');
 AppendMenu (Menu, MF_STRING, CMD_SECOND, ' ');
 TrackPopupMenu (Menu, TPM_LEFTALIGN or TPM_LEFTBUTTON, xPos, yPos, 0, Wnd, Dummy^);
 DestroyMenu (Menu)
 end;

procedure ProcessCreate (Wnd : HWnd);
 var
   btn : HWnd;
   lF : TLogFont;
   hF : HFont;
 begin
 SystemParametersInfo (SPI_GETICONTITLELOGFONT, 0, @lF, 0);
 hF := CreateFontIndirect (@lf);
 btn := CreateWindowEx (
                       0,
                       'BUTTON',
                       ' ',
                       WS_CHILD or WS_VISIBLE
                                or BS_PUSHBUTTON or BS_CENTER or BS_VCENTER,
                       200, 30,
                       120, 24,
                       Wnd,
                       CMD_FIRST,
                       HInstance,
                       nil
                       );
 SendMessage (btn, WM_SETFONT, hF, 0);
 btn := CreateWindowEx (
                       0,
                       'BUTTON',
                       ' ',
                       WS_CHILD or WS_VISIBLE
                                or BS_PUSHBUTTON or BS_CENTER or BS_VCENTER,
                       200, 60,
                       120, 24,
                       Wnd,
                       CMD_SECOND,
                       HInstance,
                       nil
                       );
 SendMessage (btn, WM_SETFONT, hF, 0);
 btn := CreateWindowEx (
                       0,
                       'BUTTON',
                       '',
                       WS_CHILD or WS_VISIBLE
                                or BS_PUSHBUTTON or BS_CENTER or BS_VCENTER,
                       200, 100,
                       120, 24,
                       Wnd,
                       CMD_EXIT,
                       HInstance,
                       nil
                       );
 SendMessage (btn, WM_SETFONT, hF, 0)
 end;


procedure ProcessCommand (Wnd : HWnd; Command : word);
 begin
 case Command of
      CMD_EXIT : PostMessage (Wnd, WM_CLOSE, 0, 0);
      CMD_FIRST : MessageBox (Wnd, ' ', '', MB_ICONASTERISK);
      CMD_SECOND : MessageBox (Wnd, ' ', '', MB_ICONASTERISK)
      end;
 end;

function WndProc (
         Wnd : HWnd;
         Msg : cardinal;
         wParam, lParam : longint
         ) : longint; stdcall;
 begin
 result := 0;
 case Msg of
      WM_COMMAND : ProcessCommand (Wnd, loword(wParam));
      WM_CONTEXTMENU : ProcessContextMenu (Wnd, loword(lParam), hiword(lParam));
      WM_CREATE : ProcessCreate (Wnd);
      WM_DESTROY : PostQuitMessage (0)
      else result := DefWindowProc (Wnd, Msg, wParam, lParam)
      end
 end;

var
  WndClass : PWndClassEx;

initialization
WndClass := new(PWndClassEx);
WndClass^.cbSize := sizeof(TWndClassEx);
WndClass^.style := CS_DBLCLKS or CS_HREDRAW or CS_OWNDC or CS_VREDRAW;
WndClass^.lpfnWndProc := @WndProc;
WndClass^.cbClsExtra := 0;
WndClass^.cbWndExtra := 0;
WndClass^.hInstance := HInstance;
WndClass^.hIcon := LoadIcon (0, IDI_ASTERISK);
WndClass^.hCursor := LoadCursor (0, IDC_ARROW);
WndClass^.hbrBackground := COLOR_BTNFACE + 1;
WndClass^.lpszMenuName := nil;
WndClass^.lpszClassName := CN_MAIN;
WndClass^.hIconSm := 0;
if RegisterClassEx (WndClass^) = 0
   then begin
        MessageBox (0, '  !', '!', MB_ICONSTOP);
        Halt (1)
        end;
dispose(WndClass)
end.